<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Home page !-->

<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<div class="container-fluid mb-4">
    <div class="card card-body">
        <div class="d-flex bd-highlight">
        <div class="p-2 bd-highlight flex-grow-1"><h3>All Departments</h3></div>
        <div class="p-2 bd-highlight"><a class="btn btn-sm btn-primary" href="<?= base_url('administrator/departments/add'); ?>">Add Department</a></div>
    </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($departments): ?>
                        <?php $i = 1; foreach($departments as $dept): ?>
                        <tr>
                            <td><?= $i++; ?></td>
                            <td><?= $dept->name; ?></td>
                            <td><?= $dept->description; ?></td>
                            <td>
                                <a href="<?= base_url('administrator/departments/edit/'.$dept->id); ?>" class="btn btn-sm btn-warning">Edit</a>
                                <a href="#" class="btn btn-sm btn-danger" onclick="deleteDepartment(<?= $dept->id; ?>)">Delete</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">No departments found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function deleteDepartment(id) {
    if(confirm('Are you sure you want to delete this department?')) {
        window.location.href = '<?= base_url('administrator/departments/delete/'); ?>' + id;
    }
}
</script>

<?= $this->endSection();?>
