<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>

<div class="row">
    <div class="col">
        <!-- print success message !-->
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <!-- print failure message !-->
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger">
        <?= $validation->listErrors()?>
        </div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<div class="container-fluid mb-4">
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-body mb-3">
                <h6 class="text-muted fw-bold">Website Traffic Statistics</h6>

                <!-- Summary Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <h5 class="card-title">Total Hits</h5>
                                <h3 class="card-text"><?= number_format($total_hits) ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h5 class="card-title">Unique Visitors</h5>
                                <h3 class="card-text"><?= count(array_unique(array_column($traffic_data, 'ip'))) ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <h5 class="card-title">Total Records</h5>
                                <h3 class="card-text"><?= count($traffic_data) ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <h5 class="card-title">Avg Hits per Visitor</h5>
                                <h3 class="card-text">
                                    <?php
                                    $unique_ips = count(array_unique(array_column($traffic_data, 'ip')));
                                    echo $unique_ips > 0 ? round($total_hits / $unique_ips, 1) : '0';
                                    ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Traffic Table -->
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>IP Address</th>
                                <th>User Agent</th>
                                <th>URL</th>
                                <th>Hits</th>
                                <th>Last Visit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($traffic_data)): ?>
                                <?php $counter = 1; ?>
                                <?php foreach($traffic_data as $traffic): ?>
                                    <tr>
                                        <td><?= $counter++ ?></td>
                                        <td><code><?= esc($traffic->ip) ?></code></td>
                                        <td>
                                            <small class="text-muted">
                                                <?= strlen($traffic->user_agent) > 50 ? substr(esc($traffic->user_agent), 0, 50) . '...' : esc($traffic->user_agent) ?>
                                            </small>
                                        </td>
                                        <td>
                                            <small>
                                                <a href="<?= esc($traffic->url) ?>" target="_blank" title="<?= esc($traffic->url) ?>">
                                                    <?= strlen($traffic->url) > 60 ? substr(esc($traffic->url), 0, 60) . '...' : esc($traffic->url) ?>
                                                </a>
                                            </small>
                                        </td>
                                        <td><span class="badge bg-primary"><?= $traffic->hits ?></span></td>
                                        <td><small><?= date('d-m-Y H:i:s', strtotime($traffic->created_at)) ?></small></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted">No traffic data available</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection();?>
