<?php

namespace Modules\Admin\Controllers;

use App\Controllers\Auth\AuthController;
use CodeIgniter\HTTP\ResponseInterface;

class Notifications extends AuthController
{
    public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
    }

    public function index()
    {
        $this->data['title'] = 'Notifications';
        $this->data['bcrumb'] = 'Notifications';
        
        // Get counts and types for filters
        $this->data['total_notifications'] = $this->notificationsModel->countByFilters($this->userdata->user_id, []);

        $this->data['types'] = $this->notificationsModel->getTypesWithCounts($this->userdata->user_id);

        return view('Modules\Admin\Views\notifications\notifications', $this->data);
    }

    public function list()
    {
        $req = $this->request;
        $filters = [];
        
        if ($req->getGet('type')) $filters['type'] = $req->getGet('type');
        if ($req->getGet('status') !== null && $req->getGet('status') !== '') $filters['status'] = $req->getGet('status');
        if ($req->getGet('from')) $filters['from'] = $req->getGet('from');
        if ($req->getGet('to')) $filters['to'] = $req->getGet('to');

        // Get filtered data
        $data = $this->notificationsModel->getByFilters($this->userdata->user_id, $filters);
        
        // Get counts for current filters
        $total_count = $this->notificationsModel->countByFilters($this->userdata->user_id, $filters);
        $unread_count = $this->notificationsModel->countByFilters($this->userdata->user_id, array_merge($filters, ['status' => 0]));

        $response = [
            'success' => true,
            'data' => $data,
            'total_count' => $total_count,
            'unread_count' => $unread_count
        ];
        
        return $this->response->setJSON($response);
    }
    
    public function exportCsv()
    {
        $req = $this->request;
        $filters = [];
        
        if ($req->getGet('type')) $filters['type'] = $req->getGet('type');
        if ($req->getGet('status') !== null && $req->getGet('status') !== '') $filters['status'] = $req->getGet('status');
        if ($req->getGet('from')) $filters['from'] = $req->getGet('from');
        if ($req->getGet('to')) $filters['to'] = $req->getGet('to');

        $data = $this->notificationsModel->getByFilters($this->userdata->user_id, $filters);

        $filename = 'notifications_export_'.date('Ymd_His').'.csv';
        $this->response->setHeader('Content-Type', 'text/csv');
        $this->response->setHeader('Content-Disposition', 'attachment; filename="'.$filename.'"');

        $out = fopen('php://output', 'w');
        fputcsv($out, ['ID','Message','Type','Status','Created At']);
        
        foreach ($data as $row) {
            $row = (array)$row;
            fputcsv($out, [
                $row['id'] ?? '',
                $row['message'] ?? '',
                $row['notification_type'] ?? '',
                $row['status'] == 0 ? 'Unread' : 'Read',
                $row['created_at'] ?? ''
            ]);
        }
        
        fclose($out);
        return $this->response;
    }
    
    public function status($id = null)
    {
        if($this->request->getMethod() == 'POST')
        {
            if ($id === null) {
                $id = $this->request->getPost('id');
            }
            
            $status = $this->request->getPost('status');
            $cData = [
                'status' => $status,
                'updated_at' => date('Y-m-d H:i:s'),
                'updated_by' => $this->userdata->user_id
            ];
            
            $results = $this->notificationsModel->update($id, $cData);
            
            if($results)
            {
                if($this->request->isAJAX())
                {
                    $response = [
                        'success' => true,
                        'msg' => 'Status changed successfully',
                        'csrf_hash' => csrf_hash()
                    ];
                    return $this->response->setJSON($response);
                } else {
                    session()->setFlashdata('success', 'Status changed successfully');
                    return redirect()->to('administrator/notifications');
                }
            } else {
                $response = [
                    'success' => false,
                    'msg' => 'Failed to change status',
                    'csrf_hash' => csrf_hash()
                ];
                return $this->response->setJSON($response);
            }
        }
        
        return $this->response->setStatusCode(405)->setJSON(['success' => false, 'msg' => 'Method not allowed']);
    }

    public function view($id = null)
    {
        if (empty($id)) {
            return $this->response->setStatusCode(400)->setJSON(['success' => false, 'msg' => 'Missing id']);
        }
        
        $n = $this->notificationsModel->find($id);
        if (!$n) {
            return $this->response->setStatusCode(404)->setJSON(['success' => false, 'msg' => 'Notification not found']);
        }
        
        // Verify user owns this notification
        if ($n['user_id'] != $this->userdata->user_id) {
            return $this->response->setStatusCode(403)->setJSON(['success' => false, 'msg' => 'Access denied']);
        }
        
        return $this->response->setJSON(['success' => true, 'data' => $n]);
    }

    public function markBulk()
{
    if ($this->request->getMethod() !== 'POST') {
        return $this->response->setStatusCode(405)->setJSON(['success' => false, 'msg' => 'Method not allowed']);
    }
    
    
    // The framework's CSRF filter will handle validation.
    // Manual check removed.
    
    
    $ids = $this->request->getPost('ids');
    $status = $this->request->getPost('status');
    
    if (empty($ids) || !is_array($ids)) {
        return $this->response->setJSON(['success' => false, 'msg' => 'No notifications selected', 'csrf_hash' => csrf_hash()]);
    }
    
    // Validate that all IDs belong to the current user
    $validIds = $this->notificationsModel
        ->where('user_id', $this->userdata->user_id)
        ->whereIn('id', $ids)
        ->findAll();
    
    if (empty($validIds)) {
        return $this->response->setStatusCode(403)->setJSON(['success' => false, 'msg' => 'No valid notifications found', 'csrf_hash' => csrf_hash()]);
    }
    
    $validIds = array_column($validIds, 'id');
    
    $updated = 0;
    foreach ($validIds as $id) {
        $result = $this->notificationsModel->update($id, [
            'status' => (int)$status,
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => $this->userdata->user_id
        ]);
        
        if ($result) $updated++;
    }
    
    $message = $status == 1 ? 'marked as read' : 'marked as unread';
    return $this->response->setJSON([
        'success' => true, 
        'msg' => "{$updated} notifications {$message} successfully",
        'csrf_hash' => csrf_hash()
    ]);
}
}