<?php

namespace Modules\Admin\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\CustomerCare\Models\CustomerFeedbackModel;


class Dashboard extends AuthController
{
    public $customerfeedbackModel;

    public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
        $this->customerfeedbackModel = new CustomerFeedbackModel();
    }

  public function index()
  {
    // display header information
	$this->data['title'] = "Dashboard";
    $this->data['bcrumb'] = "Dashboard";

    $this->data['activities'] = $this->notificationsModel->getLatestActivities($this->userdata->user_id);

    // Get website traffic statistics
    $this->data['total_hits'] = $this->webtrafficModel->getTotalHits();

    // Get total counts for dashboard
    $this->data['total_posts'] = $this->postsModel->where('content_type_id', 2)->where('deleted_at', null)->countAllResults();
    $this->data['total_pages'] = $this->postsModel->where('content_type_id', 1)->where('deleted_at', null)->countAllResults();
    $this->data['total_downloads'] = $this->downloadsModel->where('deleted_at', null)->countAllResults();

	return view('Modules\Admin\Views\dashboard\dashboard', $this->data);
  }
  
    public function view_hit_count()
    {
        // display header information
        $this->data['title'] = "Website Traffic Statistics";
        $this->data['bcrumb'] = "Traffic Statistics";

        // Get detailed traffic data
        $this->data['traffic_data'] = $this->webtrafficModel->getAll();
        $this->data['total_hits'] = $this->webtrafficModel->getTotalHits();

        return view('Modules\Admin\Views\dashboard\traffic_stats', $this->data);
    }

    public function getStates($country_id)
    {
        $states = $this->stateModel->where('country_id', $country_id)->findAll();
        return $this->response->setJSON($states);
    }

    public function getCities($state_id)
    {
        $cities = $this->cityModel->where('state_id', $state_id)->findAll();
        return $this->response->setJSON($cities);
    }
}
