<?php

namespace Modules\Admin\Controllers;

use App\Controllers\Auth\AuthController;

class AdminDepartments extends AuthController
{
    public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
    }

    public function index()
    {
        $this->data['title'] = "Departments";
        $this->data['bcrumb'] = 'All Departments';

        $this->data['departments'] = $this->departmentModel->getAll();

        return view('Modules\Admin\Views\departments\all_departments', $this->data);
    }

    public function addDepartment()
    {
        $this->data['title'] = 'Add Department';
        $this->data['bcrumb'] = 'Add Department';

        if($this->request->getMethod() == 'POST')
        {
            $validation = \Config\Services::validation();

            //Rules Set
            $rules = [
                'name'    => ["label"=>"Department Name", "rules"=>"required"],
            ];

            if ($this->validate($rules))
            {
                $deptData = [
                    'name' 			=> $this->request->getVar('name'),
                    'description' 	=> $this->request->getVar('description'),
                ];
                $results = $this->departmentModel->save($deptData);
                if($results)
                {
                    // Send notification for department creation
                    $adminmessage = 'Department: ' . $this->request->getVar('name') . ' has been <strong>CREATED</strong>';
                    $notificationType = 'organization';
                    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                    session()->setFlashdata('success', 'Department added successfully', 3);
                    return redirect()->to('administrator/departments');
                }else
                {
                    session()->setTempdata('error', 'Sorry! Department not added', 3);
                    return redirect()->to('administrator/departments/add');
                }
            }else{
                $this->data['validation'] = $this->validator;
            }
        }
        return View('Modules\Admin\Views\departments\add_department', $this->data);
    }

    public function editDepartment($id)
    {
        $department = $this->departmentModel->find($id);
        $this->data['title'] = 'Edit '.$department['name'];
        $this->data['bcrumb'] = $department['name'] .' Details';

        $this->data['department'] = $department;

        return View('Modules\Admin\Views\departments\edit_department', $this->data);
    }

    public function updateDepartment()
    {
        $this->data['title'] = 'Update Department';
        $this->data['bcrumb'] = 'Update Department';

        $id = $this->request->getVar('id');
        if($this->request->getMethod() == 'POST')
        {
            $validation = \Config\Services::validation();

            //Rules set
            $rules = [
                'name'    => ["label"=>"Department Name", "rules"=>"required"],
            ];

            if ($this->validate($rules))
            {
                $deptData = [
                    'name' 			=> $this->request->getVar('name'),
                    'description' 	=> $this->request->getVar('description'),
                ];
                $results = $this->departmentModel->update($id, $deptData);
                if($results)
                {
                    // Send notification for department update
                    $adminmessage = 'Department: ' . $this->request->getVar('name') . ' has been <strong>UPDATED</strong>';
                    $notificationType = 'organization';
                    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                    session()->setFlashdata('success', 'Department updated successfully', 3);
                    return redirect()->to('administrator/departments');
                }else
                {
                    session()->setTempdata('error', 'Sorry! Department not updated', 3);
                    return redirect()->to('administrator/departments/edit/'.$id);
                }
            }else{
                $this->data['validation'] = $this->validator;
            }
        }
        return View('Modules\Admin\Views\departments\edit_department', $this->data);
    }

    public function deleteDepartment($id)
    {
        // Get department info before deletion for notification
        $department = $this->departmentModel->find($id);
        $deptName = $department['name'] ?? 'ID '.$id;
        
        $this->departmentModel->delete($id);
        
        // Send notification for department deletion
        $adminmessage = 'Department: ' . $deptName . ' has been <strong>DELETED</strong>';
        $notificationType = 'organization';
        $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

        session()->setFlashdata('success', 'Department deleted successfully', 3);
        return redirect()->to('administrator/departments');
    }
}