<?php

namespace Modules\Admin\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Inventory routes.
$routes->group('administrator', ['filter' => ['isLoggedIn' , 'checkPermission'], 'namespace' => 'Modules\Admin\Controllers'],   static function($routes){
 

    $routes->GET('/', 'Dashboard::index');
    $routes->GET('profile', 'AdminUsers::profile');
    $routes->POST('profile', 'AdminUsers::profile');
    $routes->POST('change-password', 'AdminUsers::changePassword');


    $routes->GET('users', 'AdminUsers::index');
    $routes->GET('users/list', 'AdminUsers::usersList');
    $routes->GET('users/add', 'AdminUsers::addUser');
    $routes->POST('users/add', 'AdminUsers::addUser');
    $routes->GET('users/edit/(:any)', 'AdminUsers::editUser/$1');
    $routes->POST('users/edit/(:any)', 'AdminUsers::editUser/$1');
    // Allow both GET and POST for delete (JS may POST via AJAX)
    $routes->match(['get','post'], 'users/delete/(:any)', 'AdminUsers::deleteUser/$1');
    $routes->POST('users/change/password', 'AdminUsers::changePassword');
    $routes->POST('users/changePwd', 'AdminUsers::changePwd');
    $routes->POST('users/change/group', 'AdminUsers::changeGroup');

    // Routes for cascading dropdowns
    $routes->GET('get-states/(:num)', 'AdminUsers::getStates/$1');
    $routes->GET('get-cities/(:num)', 'AdminUsers::getCities/$1');

    $routes->GET('departments', 'AdminDepartments::index');
    $routes->GET('departments/add', 'AdminDepartments::addDepartment');
    $routes->POST('departments/add', 'AdminDepartments::addDepartment');
    $routes->GET('departments/edit/(:any)', 'AdminDepartments::editDepartment/$1');
    $routes->POST('departments/update', 'AdminDepartments::updateDepartment');
    $routes->GET('departments/delete/(:any)', 'AdminDepartments::deleteDepartment/$1');

 

});

//Administrator settings not affected by permissions
$routes->group('administrator', ['filter' => 'isLoggedIn', 'namespace' => 'Modules\Admin\Controllers'],   static function($routes){
 

    $routes->get('notifications', 'Notifications::index');
    $routes->get('notifications/list', 'Notifications::list');
    $routes->post('notifications/status/(:num)', 'Notifications::status/$1');
    $routes->post('notifications/status', 'Notifications::status'); 
    $routes->get('notifications/exportCsv', 'Notifications::exportCsv');
    $routes->get('notifications/view/(:num)', 'Notifications::view/$1');
    $routes->post('notifications/mark-bulk', 'Notifications::markBulk');

    $routes->GET('hits', 'Dashboard::view_hit_count');
  
});


