<?php

namespace App\Models;

use CodeIgniter\I18n\Time;
use CodeIgniter\Model;


class WebTrafficModel extends Model
{
    protected $table          = 'web_traffic';
    protected $primaryKey     = 'id';

    protected $useSoftDeletes = false;
    protected $allowedFields  = [
        'ip',
        'user_agent',
        'url',
        'hits',
    ];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    public function getAll()
    {
        $builder = $this->db->table('web_traffic');
        $builder->where('deleted_at', null);
        $results = $builder->get()->getResult();
        return $results;
    }

    public function getTotalHits()
    {
        $builder = $this->db->table('web_traffic');
        $builder->selectCount('hits');
        $results = $builder->countAllResults();
        return  $results;
    }


}
