<?php
namespace App\Models;

use CodeIgniter\Model;

class UsersModel extends Model
{

    protected $table        = 'usc_users';
    protected $primaryKey = 'id';

    protected $returnType     = 'object';

    // Added country_id/state_id/city_id so location fields are writable via save/update
    protected $allowedFields = ['first_name', 'last_name', 'email',  'photo', 'mobile', 'address',  'password', 'birthday', 'position', 'org_name', 'gender', 'description', 'department_id', 'country_id', 'state_id', 'city_id', 'status', 'relative_name', 'relative_phone', 'relative_relationship', 'twitter', 'facebook', 'linkedin', 'instagram', 'last_active', 'created_by', 'updated_by', 'updated_at'];

    protected $useTimestamps    = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*');
        // use the unified table prefixes for auth/group relations
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left');
        $builder->join('usc_user_groups as ug', 'ug.id=uag.group_id', 'left');
        $builder->where('u.deleted_at', null);
        $builder->where('u.id !=', 1);
        $result = $builder->get()->getResult();
        return $result;
    }
    

    //Check User Email Availability
    public function verifyEmail($email)
    {
        $builder = $this->db->table('usc_users as u');
        $builder->where('u.email', $email);
        $result = $builder->get()->getRow();
        return $result;
    }

    //update password
    public function updatePassword($id, $password){
        $builder = $this->db->table('usc_users');
        $builder->where('id', $id);
        $builder->update(['password' =>$password]);
        if($this->db->affectedRows()==1)
        {
            return true;
        }else{
            return false;
        }
    }

    public function singleUser($user)
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*, ug.name as group, uag.group_id, co.country_name, st.name as state_name, ci.name as city_name, cd.name as org_name');
        // use consistent prefixed auth/group tables
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->join('usc_user_groups as ug', 'ug.id=uag.group_id', 'left');
        $builder->join('usc_cities as ci', 'ci.id=u.city_id', 'left');
        $builder->join('usc_states as st', 'st.id=u.state_id', 'left');
        $builder->join('usc_countries as co', 'co.country_id=u.country_id', 'left');
        $builder->join('company_department as cd', 'cd.id = u.department_id', 'left');
        $builder->where('u.id', $user);
        $results = $builder->get()->getRow();
        return $results;
    }

    public function getAllUsers()
    {
        $builder = $this->db->table('usc_users as u');
        // FIX: Added 'ug.name as role' to satisfy the view's expectation ($u->role)
        $builder->select('u.*, ug.name as group, ug.name as role, uag.group_id, cd.name as org_name');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->join('usc_user_groups as ug', 'ug.id=uag.group_id', 'left');
        $builder->join('company_department as cd', 'cd.id = u.department_id', 'left');
        $builder->where('u.deleted_at', null);
        $builder->where('uag.user_type', 'admin');
        $result = $builder->get()->getResult();
        return $result;
    }

    //Get Super Admins  Notifications
    public function getSuperAdminUsers()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->where('uag.group_id', 1);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Get Super Admins & Admins for  Notifications
    public function getAdminUsers()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->whereIn('uag.group_id', [1, 2]);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Get Super Admins, Admins & Billing Manager for  Notifications
    public function getBillingUsers()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->whereIn('uag.group_id', [1, 2,3]);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Get Super Admins & Admins for  Notifications
    public function getLTUsers()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->whereIn('uag.group_id', [1,2,3,4,5,6]);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Display all Users accessing the Administrator Dashboard
    public function getOnlyDashboardUsers()
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*, ug.name as group, uag.group_id');
        $builder->join('usc_user_auth_group as uag', 'uag.user_id = u.id', 'left' );
        $builder->join('usc_user_groups as ug', 'ug.id=uag.group_id');
        $builder->where('u.deleted_at', null);
        $builder->whereIn('uag.group_id', [1, 2, 3, 4, 5]);
        $results = $builder->get()->getResult();
        return $results;
    }

    

    //Find a USER & the Group
    public function findUserGroup($id)
    {
        $builder = $this->db->table('usc_users as u');
        $builder->select('u.*, group, secret, ag.id as group_id, co.country_name, st.name as state_name, ci.name as city_name');
        $builder->join('auth_identities as ai', 'ai.user_id=u.id');
        $builder->join('auth_groups_users as ag', 'ag.user_id = u.id');
        $builder->join('usc_cities as ci', 'ci.id=u.city_id');
        $builder->join('usc_states as st', 'st.id=u.state_id');
        $builder->join('usc_countries as co', 'co.country_id=u.country_id');
        $builder->where('u.id', $id);
        $results = $builder->get()->getRow();
        return $results;
    }

    

}