<?php

namespace App\Models;

use CodeIgniter\Model;

class UserActivateTokensModel extends Model
{
    protected $table = 'usc_user_activate_tokens';
    protected $primaryKey = 'id';

    protected $allowedFields = ['hashed_token', 'user_id', 'ip_address', 'expires', 'updated_at'];

    protected $useTimestamps = false;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    //Verify User Token - reset password
    public function verifyToken($token)
    {
        $builder = $this->db->table('user_activate_tokens');
        $builder->where('hashed_token', $token);
        return $result = $builder->get()->getRow();
    }
}