<?php

namespace App\Models;

use CodeIgniter\Model;

class SuppliersModel extends Model
{
    protected $table = 'supplier';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'photo', 'tel', 'email', 'address', 'city_id', 'state_id', 'country_id', 'area_code', 'contact_person', 'website', 'description', 'status', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    //Get all Branches
    public function getAll()
    {
        $builder = $this->db->table('supplier as s');
        $builder->select('s.*, u.first_name, u.last_name, ci.name as city_name, co.name as country_name');
        $builder->join('cities as ci', 'ci.id=s.city_id');
        $builder->join('states as st', 'st.id=s.state_id');
        $builder->join('countries as co', 'co.id=s.country_id');
        $builder->join('users as u', 'u.id=s.created_by');
        $builder->where('s.deleted_at', null);
		$result = $builder->get()->getResult();
		return $result;
    }

    //Get Single Supplier
    public function getSingleSupplier($id)
    {
        $builder = $this->db->table('supplier as s');
        $builder->select('s.*, s.email, u.first_name, u.last_name,  ci.name as city_name, st.name as state_name, co.name as country_name');
        $builder->join('cities as ci', 'ci.id=s.city_id');
        $builder->join('states as st', 'st.id=s.state_id');
        $builder->join('countries as co', 'co.id=s.country_id');
        $builder->join('users as u', 'u.id=s.created_by');
        $builder->where('s.id', $id);
		$result = $builder->get()->getRow();
		return $result;
    }

    

}