<?php

namespace App\Models;

use CodeIgniter\Model;

class StateModel extends Model
{
    protected $table = 'usc_states';
    protected $primaryKey = 'id';

    protected $allowedFields = [ 'name', 'slug', 'country_id', 'status'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = false;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        return $this->findAll();
    }

    public function getCities($stateId)
    {
        $cityModel = new CityModel();
        return $cityModel->where('state_id', $stateId)
                        ->where('status', 1)
                        ->orderBy('name')
                        ->findAll();
    }

}
