<?php

namespace App\Models;

use CodeIgniter\Model;

class RegisterModel extends Model {
	
	protected $table      = 'usc_users';
    protected $primaryKey = 'id ';
	
	protected $allowedFields = ['first_name', 'last_name', 'email',  'photo', 'mobile', 'tel', 'address',  'password', 'birthday', 'position', 'gender', 'org_name', 'description', 'city_id', 'state_id', 'country_id', 'social_provider', 'status', 'facebook', 'twitter', 'whatsapp', 'instagram', 'last_active',  'website', 'created_by', 'updated_by', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';



// change user status from inactive to Active after Auth Code approval
	//Update user status - ACTIVE
    public function updateStatus($status)
	{
		$builder = $this->db->table('users as u');
		$builder->where('id', $status);
		$builder->update(['status'=> 'active']);
		$result = $builder->get()->getRow();
		return $result;
	}

    //update password
    public function updatePassword($id, $password){
		$builder = $this->db->table('users');
		$builder->where('id', $id);
		$builder->update(['password' =>$password]);
		if($this->db->affectedRows()==1)
        {
			return true;
		}else{
			return false;
		}
	}
    
	//Get USER ID
    public function getUserId($id)
    {
        $builder = $this->db->table('users as u');
        $builder->where('u.id', $id);
        return $result = $builder->get()->getRow();
    }

	//Verify if User exists in the system || check Email Availability
    public function verifyEmail($email)
    {
        $builder = $this->db->table('users as u');
        $builder->where('u.email', $email);
        $result = $builder->get()->getRow();
		return $result;
    }
}
