<?php

namespace App\Models;

use CodeIgniter\Model;

class DepartmentModel extends Model
{
    protected $table = 'company_department';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'description', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('company_department');
        $builder->where('deleted_at', null);
        return $results = $builder->get()->getResult();
    }



}
