<?php

namespace App\Models;

use CodeIgniter\Model;

class DeliveryModel extends Model
{
    protected $table = 'delivery';
    protected $primaryKey = 'id';

    protected $allowedFields = [ 'name', 'description', 'status', 'price',];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    
    public function getAll()
    {
        $status = 1;
        $builder = $this->db->table('delivery');
        $builder->where('status', $status);
        return $result = $builder->get()->getResult();
    }

    public function getSingleDeliveryMethod($id)
    {
        $builder = $this->db->table('delivery');
        $builder->where('id', $id);
        return $result = $builder->get()->getRow();
    }
}