<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Models\CountryModel;
use App\Models\StateModel;
use App\Models\CityModel;

class CountryStateCityModel extends Model {


    public function __construct() {
        parent::__construct();
        //$this->load->database();
        $db = \Config\Database::connect();
    }

    public function getCountries() {
       $query = $this->db->query('select * from usc_countries');
       return $query->getResult();
    }

    public function getStates($countryId) {
        $builder = $this->db->table('usc_states as st');
        $builder->select('st.id, st.name');
        $builder->where('st.country_id', $countryId);
        $builder->where('st.status', 1);
        $builder->orderBy('st.name');
        return $builder->get()->getResultArray();
    }

    public function getCities($stateId)
    {
        $builder = $this->db->table('usc_cities as ci');
        $builder->select('ci.id, ci.name');
        $builder->where('ci.state_id', $stateId);
        $builder->where('ci.status', 1);
        $builder->orderBy('ci.name');
        return $builder->get()->getResultArray();
    }




}
