<?php

namespace App\Models;

use CodeIgniter\Model;

class CountryModel extends Model
{
    protected $table = 'usc_countries';
    protected $primaryKey = 'country_id';

    protected $allowedFields = ['sortname', 'country_name', 'slug', 'phonecode', 'status'];

    protected $returnType     = 'array';


    public function getAll()
    {
        return $this->where('status', 1)->orderBy('country_name')->findAll();
    }

    public function getById($id)
    {
        return $this->where('country_id', $id)->first();
    }

    public function getStates($countryId)
    {
        $stateModel = new StateModel();
        return $stateModel->where('country_id', $countryId)
                         ->where('status', 1)
                         ->orderBy('name')
                         ->findAll();
    }
}
