<?php

namespace App\Models;

use CodeIgniter\Model;

class CityModel extends Model
{
    protected $table = 'usc_cities';
    protected $primaryKey = 'id';

    protected $allowedFields = [ 'name', 'slug', 'state_id', 'status'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = false;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';


    public function getAll()
    {
        return $this->findAll();
    }

}
