<?php

namespace App\Libraries;

use App\Models\NotificationsModel;
use App\Models\UsersModel;

class AuditLogger
{
    protected $notificationsModel;
    protected $usersModel;

    public function __construct()
    {
        $this->notificationsModel = new NotificationsModel();
        $this->usersModel = new UsersModel();
    }

    /**
     * Log an entry to all admin users.
     *
     * @param string $message
     * @param string $type
     * @param int|null $actorId
     * @return void
     */
    public function logForAdmins(string $message, string $type = 'system', $actorId = null)
    {
        $admins = $this->usersModel->getAdminUsers();
        foreach ($admins as $admin) {
            $this->notificationsModel->save([
                'message' => $message,
                'user_id' => $admin->id,
                'notification_type' => $type,
                'created_by' => $actorId,
            ]);
        }
    }

    /**
     * Log an entry for a single user.
     *
     * @param int $userId
     * @param string $message
     * @param string $type
     * @param int|null $actorId
     * @return void
     */
    public function logForUser(int $userId, string $message, string $type = 'system', $actorId = null)
    {
        $this->notificationsModel->save([
            'message' => $message,
            'user_id' => $userId,
            'notification_type' => $type,
            'created_by' => $actorId,
        ]);
    }

    /**
     * Log an entry for multiple user IDs.
     *
     * @param array $userIds
     * @param string $message
     * @param string $type
     * @param int|null $actorId
     * @return void
     */
    public function logMultiple(array $userIds, string $message, string $type = 'system', $actorId = null)
    {
        foreach ($userIds as $uid) {
            $this->notificationsModel->save([
                'message' => $message,
                'user_id' => $uid,
                'notification_type' => $type,
                'created_by' => $actorId,
            ]);
        }
    }
}
