<?php
/**
 *  This helper file contains all LTcms short version helpers that can be used throughout the CMS
 *  You can use them where appropriate in your system
 * 
 */

// Create a helper function
 function getVarOrNull($key) {
    $value = $this->request->getVar($key);
    return !empty($value) ? $value : null;
}

//Ordering of Post Blocks
function shiftOrdering($postId, $newOrder, $blockId)
{
    // Get all blocks ordered by ordering
    $blocks = $this->where('post_id', $postId)
                   ->where('id !=', $blockId)
                   ->orderBy('ordering', 'ASC')
                   ->findAll();

    $order = 1;
    foreach ($blocks as $b) {
        if ($order == $newOrder) {
            $order++; // leave space for updated block
        }
        $this->update($b['id'], ['ordering' => $order]);
        $order++;
    }
}

/**
 * Render heading with emphasized text
 * Uses the title_emphasized field to wrap specific text in <span> tags
 * 
 * @param string $heading The full heading text
 * @param string $emphasized The text to emphasize (wrap in span)
 * @param bool $escape Whether to escape the text (default: true)
 * @return string The formatted HTML with emphasized text wrapped in <span> tags
 */
function renderEmphasized($heading, $emphasized = '', $escape = true)
{
    if (empty($heading)) {
        return '';
    }
    
    // If no emphasized text provided, return heading as is
    if (empty($emphasized)) {
        return $escape ? esc($heading) : $heading;
    }
    
    // Replace the emphasized portion with span-wrapped version in-place
    if ($escape) {
        // Escape the heading first, then replace the emphasized portion with span-wrapped version
        $escapedHeading = esc($heading);
        $escapedEmphasized = esc($emphasized);
        return str_replace($escapedEmphasized, '<span>' . $escapedEmphasized . '</span>', $escapedHeading);
    } else {
        return str_replace($emphasized, '<span>' . $emphasized . '</span>', $heading);
    }
}

