<?php

namespace App\Controllers\Front;

use App\Controllers\BaseController;


class FrontPosts extends BaseController
{
    public function __construct()
    {
        
    }

    public function allNews()
    {
        helper('ltcms');

        $metadata = $this->postsModel->getPageMetadataByAlias('news');

        if ($metadata) {
            $this->data = [
                'title' => $metadata['title'] ?? 'News & Updates - ABC Capital Bank',
                'tagline' => $metadata['excerpt'] ?? 'Stay updated with the latest news and announcements',
                'description' => $metadata['metadesc'] ?? 'Stay updated with the latest news and announcements from ABC Capital Bank Uganda.',
                'keywords' => $metadata['metakey'] ?? 'news, updates, announcements, ABC Capital Bank Uganda',
                'page_type' => 'news',
                'page_metadata' => $metadata,
                'featured_image' => $metadata['photo'] ?? base_url('assets/front_assets/images/logo-ABC-Capital-Bank-Uganda.gif'),
                'tags' => $metadata['tags_array'] ?? []
            ];
        } else {
            $this->data = [
                'title' => 'News & Updates - ABC Capital Bank',
                'tagline' => 'Stay updated with the latest news and announcements',
                'description' => 'Stay updated with the latest news and announcements from ABC Capital Bank Uganda.',
                'keywords' => 'news, updates, announcements, ABC Capital Bank Uganda',
                'page_type' => 'news',
                'featured_image' => base_url('assets/front_assets/images/logo-ABC-Capital-Bank-Uganda.gif'),
                'tags' => ['news', 'updates', 'announcements']
            ];
        }

        // Get category filter from URL parameter
        $categoryId = $this->request->getGet('category');

        // Get categories for filter dropdown
        $this->data['categories'] = $this->postsModel->getCategoriesWithPostCounts();

        // Pagination setup
        $perPage = 9; // Show 9 posts per page (3x3 grid)
        $page = $this->request->getGet('page') ?? 1;

        // Get posts based on category filter with pagination
        if ($categoryId) {
            $this->data['posts'] = $this->postsModel->getPostsByCategoryPaginated($categoryId, $perPage, $page);
            $this->data['pager'] = $this->postsModel->pager;
            $this->data['currentCategory'] = $categoryId;
        } else {
            $this->data['posts'] = $this->postsModel->getAllPostsPaginated($perPage, $page);
            $this->data['pager'] = $this->postsModel->pager;
            $this->data['currentCategory'] = null;
        }

        $this->data['hero_banner'] = $this->bannersModel->getPageHeroBannerByUrl('news');

        return view('website/posts/all_posts', $this->data);
    }

    public function newsArticle($id = null)
    {
        $this->data['pg'] = $this->postsModel->getSinglePost($id);

        //Meta info for pages
        $this->data['title'] = $this->data['pg']->title ?? 'Blog Post';
        $this->data['tagline']= 'ABC Capital Bank  Uganda Ltd';
        $this->data['description']= $this->data['pg']->metadesc ?? $this->data['pg']->excerpt ?? 'ABC Capital Bank Uganda Limited blog post';
        $this->data['keywords']= $this->data['pg']->metakey ?? 'ABC Capital Bank, Uganda banking, financial news';

        $this->data['posts'] = $this->postsModel->where('status', 'published')->where('content_type_id', 2)->findAll(5);

        // Get categories for sidebar
        $this->data['categories'] = $this->postsModel->getCategoriesWithPostCounts();

        return view('App\Views\website\posts\single_post', $this->data);
    }

}