<?php

namespace App\Controllers\Front;

use App\Controllers\BaseController;

class FooterPages extends BaseController
{
    protected $data = [];

    public function __construct()
    {
        $this->data['title'] = 'ABC Capital Bank';
        $this->data['description'] = 'ABC Capital Bank - Your trusted banking partner';
        $this->data['keywords'] = 'banking, finance, loans, savings, Uganda';
    }

    // Quick Links Pages
    public function careers()
    {
        $this->data['title'] = 'Careers - ABC Capital Bank';
        $this->data['page_title'] = 'Careers';
        $this->data['breadcrumb'] = 'Careers';

        

        return view('website/footer_pages/careers', $this->data);
    }

    public function news()
    {
        $this->data['title'] = 'News & Updates - ABC Capital Bank';
        $this->data['page_title'] = 'News & Updates';
        $this->data['breadcrumb'] = 'News & Updates';

        

        return view('website/footer_pages/news', $this->data);
    }

    public function faqs()
    {
        $this->data['title'] = 'FAQs - ABC Capital Bank';
        $this->data['page_title'] = 'Frequently Asked Questions';
        $this->data['breadcrumb'] = 'FAQs';
        
       

        return view('website/footer_pages/faqs', $this->data);
    }

    public function reports()
    {
        $this->data['title'] = 'Annual Reports - ABC Capital Bank';
        $this->data['page_title'] = 'Annual Reports';
        $this->data['breadcrumb'] = 'Annual Reports';
        
        

        return view('website/footer_pages/reports', $this->data);
    }

    public function bids()
    {
        $this->data['title'] = 'Bids and Tenders - ABC Capital Bank';
        $this->data['page_title'] = 'Bids and Tenders';
        $this->data['breadcrumb'] = 'Bids and Tenders';
         
       

        return view('website/footer_pages/bids', $this->data);
    }

    // Banking Services Pages
    public function loans()
    {
        $this->data['title'] = 'Loans & Mortgages - ABC Capital Bank';
        $this->data['page_title'] = 'Loans & Mortgages';
        $this->data['breadcrumb'] = 'Loans & Mortgages';
        
        

        return view('website/footer_pages/loans', $this->data);
    }

    public function savings()
    {
        $this->data['title'] = 'Saving Accounts - ABC Capital Bank';
        $this->data['page_title'] = 'Saving Accounts';
        $this->data['breadcrumb'] = 'Saving Accounts';
        
        

        return view('website/footer_pages/savings', $this->data);
    }

    public function bankingWays()
    {
        $this->data['title'] = 'Ways to Bank - ABC Capital Bank';
        $this->data['page_title'] = 'Ways to Bank';
        $this->data['breadcrumb'] = 'Ways to Bank';
        
        

        return view('website/footer_pages/banking_ways', $this->data);
    }

    // Who We Are Pages
    public function about()
    {
        $this->data['title'] = 'About Us - ABC Capital Bank';
        $this->data['page_title'] = 'About Us';
        $this->data['breadcrumb'] = 'About Us';
         
       

        return view('website/footer_pages/about', $this->data);
    }

    public function boardOfDirectors()
    {
        $this->data['title'] = 'Board of Directors - ABC Capital Bank';
        $this->data['page_title'] = 'Board of Directors';
        $this->data['breadcrumb'] = 'Board of Directors';
        
        

        return view('website/footer_pages/board_directors', $this->data);
    }

    public function team()
    {
        $this->data['title'] = 'Management Team - ABC Capital Bank';
        $this->data['page_title'] = 'Management Team';
        $this->data['breadcrumb'] = 'Management Team';
        
        

        return view('website/footer_pages/team', $this->data);
    }

    public function governance()
    {
        $this->data['title'] = 'Corporate Governance - ABC Capital Bank';
        $this->data['page_title'] = 'Corporate Governance';
        $this->data['breadcrumb'] = 'Corporate Governance';
        

        return view('website/footer_pages/governance', $this->data);
    }

    public function socialResponsibility()
    {
        $this->data['title'] = 'Corporate Social Responsibility - ABC Capital Bank';
        $this->data['page_title'] = 'Corporate Social Responsibility';
        $this->data['breadcrumb'] = 'Corporate Social Responsibility';
        

        return view('website/footer_pages/social_responsibility', $this->data);
    }
}
