<?php

namespace App\Constants;

/**
 * ActivityTypes class
 *
 * This class defines constants representing different activity types used in the application.
 *
 * @namespace App\Constants
 */
class ActivityTypes
{


    //FILE LOGS
    const FILE_UPLOADED = 'file_uploaded';
    const FILE_EDITED = 'file_edited';
    const FAILED_FILE_UPLOAD = 'failed_file_upload';
    const FILE_DELETION = 'file_delete';

    


    // Add more activity types as needed

    /**
     * Gets the description for a given activity type.
     *
     * @param string $type The activity type.
     * @return string The description of the activity type, or "Unknown Activity" if not found.
     */
    public static function getDescription($type)
    {
        $descriptions = [
            

            //Files
            self::FILE_UPLOADED => 'File Uploaded',
            self::FILE_EDITED => 'File Edited',
            self::FAILED_FILE_UPLOAD => 'File Upload Failed',
            self::FILE_DELETION => 'File Deleted',

            
            // Add more descriptions as needed
        ];

        return $descriptions[$type] ?? 'Unknown Activity';
    }
}