/** Settings JS for the Networks Settings */
var save_method;

//Change Date DB to Bootstrap format
function dateToYMD(date) {
    var d = date.getDate();
    var m = date.getMonth() + 1; //Month from 0 to 11
    var y = date.getFullYear();
    return '' + y + '-' + (m<=9 ? '0' + m : m) + '-' + (d <= 9 ? '0' + d : d);
}
   
/**====================================================
   * NOTIFICATIONS
 ======================================================**/
 var table_notifications_list;

$(document).ready(function () {
    table_notifications_list = $('#notification-list').DataTable({
        "ajax": base_url + "/administrator/notifications/list",
        "rowId": function (a) {
            return 'noti-' + a.id;
        },
        "columns": [
            { "data": "created_at" },
            { "data": "message" },
            {
                "orderable": false,
                "data": null,
                "render": function (data, type, row) {
                    var statusIcon = (data["status"] == 1) ? 'bi-check-circle-fill text-primary' : 'bi-check-circle-fill text-muted';
                    var statusLabel = (data["status"] == 1) ? 'Mark Unread' : 'Mark Read';
                    return '<label class="switch"><input class="cstatus" data-id="' + data["id"] + '" value="' + data["status"] + '" type="checkbox"><i class="bi ' + statusIcon + ' fs-6 align-items-center" aria-hidden="true"></i></label>';
                }
            }
        ],
        "order": [[0, 'Desc']],
        "paging": true,
        "ordering": true,
        "info": false,
        "filter": false,
        "searching": false,
        "rowCallback": function (row, data) {
            $(row).addClass('row-clickable');
        }
    });

    /**Notification Status */
    $(document).on("change", ".cstatus", function (e) {
        var status = $(this).val();
        var id = $(this).data('id');
        if (status == 1) {
            status = 0;
        }
        $.ajax({
            url: base_url + '/administrator/notifications/status/' + id,
            type: "POST",
            data: { csrf_token_name: csrfToken, status: status, id: id, },
            success: function (data) {
                if (data.success == true) {
                    if (status == 1) {
                        toastr.warning("This notification is marked unread");
                    } else {
                        toastr.success("This notification is marked read");
                    }
                    table_notifications_list.ajax.reload();
                }
            }
        });
    });

    /**Make entire row clickable */
    $('#notification-list tbody').on('click', 'tr.row-clickable', function () {
        var checkbox = $(this).find('.cstatus');
        checkbox.prop('checked', !checkbox.prop('checked'));
        checkbox.trigger('change');
    });
});

