/** ========================================================================
 * Pages and Categories
 * ========================================================================**/

// Autocomplete for link input (search pages/posts/menu links)
(function() {
  var debounceTimer = null;
  var $link = $('#link');
  var $results = $('#linkSearchResults');

  function clearSelection() {
    $('#selected_link_id').val('');
    $('#selected_link_type').val('');
    // make populated fields editable again
    $('input[name="title"]').prop('readonly', false);
    $('textarea[name="description"]').prop('readonly', false);
    $('input[name="link_text"]').prop('readonly', false);
  }

  function populateFields(item) {
    if (!item) return;
    // Determine canonical link (menu_link > slug > alias)
    var canonical = item.menu_link || item.slug || item.alias || '';
    if (canonical) {
      $('input[name="link"]').val(canonical);
    }
    if (item.title) {
      $('input[name="title"]').val(item.title).prop('readonly', true);
    }
    if (item.excerpt) {
      $('textarea[name="description"]').val(item.excerpt).prop('readonly', true);
    }
    // link text: only populate if present
    if (item.title && !$('input[name="link_text"]').val()) {
      $('input[name="link_text"]').val(item.title).prop('readonly', true);
    }
    // photo preview if available
    if (item.photo) {
      $('#postImgPreview').html('<img src="' + item.photo + '" class="img-thumbnail" style="height: 230px">');
    }

    $('#selected_link_id').val(item.id);
    $('#selected_link_type').val(item.type);
  }

  // expose for initial population
  window.populateLinkFields = populateFields;
  window.clearLinkSelection = clearSelection;

  function renderResults(items) {
    if (!items || items.length === 0) {
      $results.hide();
      $results.empty();
      return;
    }
    $results.empty();
    items.forEach(function(it) {
      var title = it.title || it.menu_link || it.slug || it.alias || '(no title)';
      var subtitle = it.menu_link || it.slug || '';
      var $item = $('<button type="button" class="list-group-item list-group-item-action d-flex justify-content-between align-items-start"></button>');
      $item.attr('data-json', JSON.stringify(it));
      $item.append('<div><div class="fw-bold">' + title + '</div><small class="text-muted">' + subtitle + '</small></div>');
      $item.append('<span class="badge bg-primary rounded-pill text-capitalize">' + (it.type || '') + '</span>');
      $results.append($item);
    });
    $results.show();
  }

  $link.on('keyup', function(e) {
    var q = $(this).val();
    // If user clears input, clear selection
    if (!q || q.length < 2) {
      renderResults([]);
      clearSelection();
      return;
    }

    clearTimeout(debounceTimer);
    debounceTimer = setTimeout(function() {
      $.ajax({
        url: base_url + '/administrator/posts/searchLinks',
        type: 'GET',
        dataType: 'json',
        headers: {
          'X-Requested-With': 'XMLHttpRequest'
        },
        data: {
          q: q
        },
        success: function(res) {
          renderResults(res);
        },
        error: function() {
          renderResults([]);
        }
      });
    }, 250);
  });

  // Click on result
  $results.on('click', '.list-group-item', function() {
    var json = $(this).attr('data-json');
    try {
      var item = JSON.parse(json);
      populateFields(item);
      $results.hide();
    } catch (err) {
      console.error(err);
    }
  });

  // If user edits link input manually, reset selection
  $link.on('input', function() {
    var id = $('#selected_link_id').val();
    if (!id) {
      // nothing selected
      $('input[name="title"]').prop('readonly', false);
      $('textarea[name="description"]').prop('readonly', false);
      $('input[name="link_text"]').prop('readonly', false);
    }
  });

  // Hide results when clicking outside
  $(document).on('click', function(e) {
    if (!$(e.target).closest('#linkSearchResults, #link').length) {
      $results.hide();
    }
  });

  // On DOM ready, if initial meta exists (from server), populate fields
  $(document).ready(function() {
    if (window.initialLinkMeta) {
      try {
        populateFields(window.initialLinkMeta);
      } catch (e) {
        console.error(e);
      }
    }

    // Image preview functionality
    $('#post_image').on('change', function(e) {
      const file = e.target.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          $('#postImgPreview').html('<img src="' + e.target.result + '" style="max-width: 100%; max-height: 100%; object-fit: contain;" alt="Preview">');
        };
        reader.readAsDataURL(file);
      }
    });

    // Click on preview area to trigger file input
    $('#postImgPreview').on('click', function() {
      $('#post_image').click();
    });

    // Drag and drop functionality
    $('#postImgPreview').on('dragover', function(e) {
      e.preventDefault();
      $(this).css('background-color', '#e3f2fd');
    });

    $('#postImgPreview').on('dragleave', function(e) {
      e.preventDefault();
      $(this).css('background-color', '');
    });

    $('#postImgPreview').on('drop', function(e) {
      e.preventDefault();
      $(this).css('background-color', '');

      const files = e.originalEvent.dataTransfer.files;
      if (files.length > 0) {
        const file = files[0];
        if (file.type.match('image.*')) {
          $('#post_image')[0].files = files;
          const reader = new FileReader();
          reader.onload = function(e) {
            $('#postImgPreview').html('<img src="' + e.target.result + '" style="max-width: 100%; max-height: 100%; object-fit: contain;" alt="Preview">');
          };
          reader.readAsDataURL(file);
        }
      }
    });
  });
})();
  //Delete Page
  function delete_post(id, name)
   {
      $("#delPageModal").modal('show');
    $("#pname").html(name);
    $("#postbtn").on('click', function(){
      $.ajax({
        url : base_url+"/administrator/pages/delete/"+id,
        type: "POST",
        dataType: "JSON",
        headers: {'X-Requested-With': 'XMLHttpRequest'},
        success: function(data)
        {
          $("#delPageModal").modal('hide');
          html = '<div class="alert alert-danger" role="alert">'+data.msg+'</div>';
          document.getElementById('showMsg').innerHTML = html;
          //toastr.error(data.msg);
          setTimeout(function(){
           location.href = base_url+"/pages";
          },800);
        }
      });
    });
   }
   /**===============================================================
    * Delete Slide
    =================================================================*/
    function delete_slide(id, name)
    {
       $("#delSlideModal").modal('show');
     $("#slidename").html(name);
     $("#del-Slidebtn").off('click').on('click', function(){
       $.ajax({
         url : base_url+"/administrator/sliders/delete/"+id,
         type: "POST",
         dataType: "JSON",
         headers: {'X-Requested-With': 'XMLHttpRequest'},
         success: function(data)
         {
           $("#delSlideModal").modal('hide');
           if(data.success){
             html = '<div class="alert alert-success" role="alert">' + data.msg + '</div>';
             document.getElementById('showMsg').innerHTML = html;
             setTimeout(function(){
              location.reload();
             },800);
           }else{
             html = '<div class="alert alert-danger" role="alert">Failed to delete slide</div>';
             document.getElementById('showMsg').innerHTML = html;
           }
         },
         error: function(xhr, status, error) {
           $("#delSlideModal").modal('hide');
           html = '<div class="alert alert-danger" role="alert">Error deleting slide</div>';
           document.getElementById('showMsg').innerHTML = html;
         }
       });
     });
    }
  /**===============================================================
   * Delete Page Category
   =================================================================*/
   function delete_sliderCategory(id, name)
   {
      $("#delCatModal").modal('show');
    $("#catname").html(name);
    $("#del-Catbtn").on('click', function(){
      $.ajax({
        url : base_url+"/administrator/sliders/category/delete/"+id,
        type: "POST",
        dataType: "JSON",
        headers: {'X-Requested-With': 'XMLHttpRequest'},
        success: function(data)
        {
          $("#delCatModal").modal('hide');
          html = '<div class="alert alert-danger" role="alert">'+data.msg+'</div>';
          document.getElementById('showMsg').innerHTML = html;
          //toastr.error(data.msg);
          setTimeout(function(){
           location.href = base_url+"/administrator/sliders/categories";
           //location.reload();
          },800);
        }
      });
    });
   }
   