$(document).ready(function() {
    // Set up AJAX defaults with CSRF token
    $.ajaxSetup({
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': csrfTokenValue // Using the global variable
        }
    });

    // Load current permissions when accordion opens
    $('.collapse').on('show.bs.collapse', function() {
        const groupId = $(this).attr('id').replace('collapse', '');
        loadCurrentPermissions(groupId);
    });

    // Handle permission checkbox changes
    $('.permissions-grid').on('change', '.perm-checkbox', function() {
        const $checkbox = $(this);
        const groupId = $checkbox.data('group');
        const permId = $checkbox.data('perm');
        const isChecked = $checkbox.is(':checked');
        
        $('#confirmMessage').text(`Are you sure you want to ${isChecked ? 'add' : 'remove'} this permission?`);
        $('#confirmModal').modal('show');
        
        // Handle confirm
        $('#confirmAction').off('click').on('click', function() {
            updatePermission(groupId, permId, isChecked ? 'add' : 'remove', $checkbox);
            $('#confirmModal').modal('hide');
        });
        
        // Handle cancel - revert checkbox state
        $('#confirmModal').off('hidden.bs.modal').on('hidden.bs.modal', function() {
            if (!$checkbox.data('update-in-progress')) {
                $checkbox.prop('checked', !isChecked);
            }
        });
    });

    function loadCurrentPermissions(groupId) {
        $.get( base_url + 'administrator/settings/show-group-permissions/' + groupId, function(data) {
            let html = '<div class="d-flex flex-wrap">';
            if (data.length > 0) {
                data.forEach(perm => {
                    html += `<span class="badge bg-primary m-1 p-2">
                                ${perm.name} 
                                <small>(${perm.module})</small>
                                <button class="btn btn-xs p-1 btn-danger ml-2 remove-perm" 
                                        data-group="${groupId}" 
                                        data-perm="${perm.id}">
                                    <i class="bi bi-x"></i>
                                </button>
                            </span>`;
                });
            } else {
                html += '<span class="text-muted">No permissions assigned</span>';
            }
            html += '</div>';
            $(`#currentPermissions${groupId}`).html(html);
            
            // Note: Checkboxes are now pre-checked from server-side PHP
            // No need to check them again via JavaScript
        });
    }

    function updatePermission(groupId, permId, action, $checkbox) {
        // Mark update in progress
        if ($checkbox) {
            $checkbox.data('update-in-progress', true);
        }
        
        const postData = {
            group_id: groupId,
            permission_id: permId,
            action: action,
            csrfTokenp : csrfTokenp
        };
        

        $.ajax({
            url: base_url + 'administrator/settings/update-group-permission',
            type: 'POST',
            data: postData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    loadCurrentPermissions(groupId);
                    toastr.success('Permission updated successfully');
                    // Update succeeded, keep checkbox state
                    if ($checkbox) {
                        $checkbox.data('update-in-progress', false);
                    }
                } else {
                    toastr.error(response.message || 'Operation failed');
                    // Revert checkbox on failure
                    if ($checkbox) {
                        $checkbox.prop('checked', action !== 'add');
                        $checkbox.data('update-in-progress', false);
                    }
                }
            },
            error: function(xhr) {
                toastr.error('Error: ' + (xhr.responseJSON?.message || xhr.statusText));
                // Revert checkbox on error
                if ($checkbox) {
                    $checkbox.prop('checked', action !== 'add');
                    $checkbox.data('update-in-progress', false);
                }
            }
        });
    }

    // Handle remove permission buttons
    $(document).on('click', '.remove-perm', function() {
        const groupId = $(this).data('group');
        const permId = $(this).data('perm');
        
        // Find and uncheck the corresponding checkbox
        const $checkbox = $(`#perm_${groupId}_${permId}`);
        
        $('#confirmMessage').text('Are you sure you want to remove this permission?');
        $('#confirmModal').modal('show');
        
        $('#confirmAction').off('click').on('click', function() {
            updatePermission(groupId, permId, 'remove', $checkbox);
            if ($checkbox.length) {
                $checkbox.prop('checked', false);
            }
            $('#confirmModal').modal('hide');
        });
        
        // Handle cancel - do nothing
        $('#confirmModal').off('hidden.bs.modal');
    });
});