/**
 * This jQuery file contains functions for Customer Settings
 * in ACB
 * Developed by LWEGATECH - www.lwegatech.com
 **/

var save_method;

/** ================================================
 *  Members List
 *===================================================*/
var table_members;
$(document).ready( function () {
  start_load()
  $(document).on('click', '[data-bs-toggle="popover"]', function () {
       $(this).popover();
   });
  table_memberss = $('#member-list').DataTable( {
  dom: 'Blfrtip',
    buttons: [
        'copy', 'csv', 'excel', 'pdf', 'print'
      ],
  "processing": true,
    "serverSide": true,
    "ajax": {
        "url": base_url + "administrator/members/list",
        "type": "GET",
        "data": function (d) {

            d.search = { "value": $('#member-list_filter input').val() };
        }
    },
  "columns": [
        { 
              "orderable": false,
              "data": null,
              render: function (data, type, row) {
                  if (data["photo"] == null) {
                      return '<img src="' + base_url + '/assets/images/no-image.gif" alt="" height="20px">';
                  } else {
                      return '<img src="' + data["photo"] + '" alt="' + data["fname"] + 'style="height:50px;width:50px;border-radius:50%;">';
                  }
              }
        },
        {
            "orderable":      true,
            "data":           null,
            render: function ( data, type, row ) {
            return '<a href="'+ base_url+"administrator/members/single-member/id="+data["id"] +'"><strong>' + data["fname"] + ' '+ data["lname"] + '</strong></a>'; 
            }
        },
        {"data": "mobile"},
       {"data": "email"},
        {"data":"organization"},
       { 
            "orderable":      false,
            "data":           null,
            render: function ( data, type, row ) {
                if( data["membership_status_id"]){
                    return '<span class="badge" style="background:'+data["color"]+';font-size:9px;">'+data["member_status"]+'</span>';
                }
            }
        },
       {"data": "professional_level"},
       {"data": "subscription_plan"},
       {"data": "city_name"},
       {"data": "country_name"},
       {
           "orderable":      false,
           "data":           null,
           render:function(data, type, row)
           {
               var btn ='<div class="dropdown">'+
                        '<button class="btn btn-light" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">'+
                        '<i class="bi bi-three-dots-vertical"></i>'+
                        '</button>'+
                        '<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">'+
                        '<li><a class="dropdown-item" title="Edit" onclick="edit_member('+data["id"]+')\" style="cursor: pointer"><small>Edit</small></a></li>'+
                        '<li><a class="dropdown-item" href="'+base_url+'administrator/members/single-member/id='+data["id"]+'"><small>View</small></a></li>'+
                        '<li><a class="dropdown-item" onclick="delete_member('+data["id"]+',\''+data["fname"]+'\')\" style="cursor: pointer"><small>Delete</small></a></li>'+
                        ' </ul>'+
                        '</div>';
                    return btn;
           }
       }
  ],
  "order": [[0, 'desc']],
  });
  setTimeout(function(){
   end_load()
   
},500)
});

//Edit Member
function edit_member(id)
{
    $('#member_Modal').modal('show');

    $.ajax({
        url:  base_url + 'administrator/members/single-member/edit='+ id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {
            $('[name="id"]').val(data.id);
            $('[name="fname"]').val(data.fname);
            $('[name="lname"]').val(data.lname);
            $('[name = "email"]').val(data.email);
            $('[name = "mobile"]').val(data.mobile);
            $('[name = "member_number"]').val(data.member_number);
            $('[name = "icold_member"]').val(data.icold_member);
            $('[name = "passport_number"]').val(data.passport_number);
            $('[name = "national_id"]').val(data.national_id);
            $('[name = "gender"]').val(data.gender);
            $('[name = "membership_type_id"]').val(data.membership_type_id);
            $('[name = "professional_level_id"]').val(data.professional_level_id);
            $('[name = "membership_status_id"]').val(data.membership_status_id);
            $('[name = "registration_type_id"]').val(data.registration_type_id);
            $('[name = "address"]').val(data.address);
            $('[name = "description"]').val(data.description);
            $('[name = "area_code"]').val(data.area_code);
            $('[name = "country_id"]').val(data.country_id);             

            $( "#state_id option:selected").val(data.state_id);
            $( "#state_id option:selected").text(data.state_name);
            $( "#city_id option:selected").val(data.city_id);
            $( "#city_id option:selected").text(data.city_name);


            //load modal
            start_load()
            $("#member_Modal").modal('show');
            $(".modal-title").text("Update Member!");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
        },500)
        }
    });
}

function delete_member(id, name)
{
  var confirmation = confirm('Are you sure you want to delete ' + name + ' ?');
  if (confirmation) {
      window.location.href = base_url + '/administrator/members/single-member/delete/' + id;
  }
}


/** =====================================================
 * ATTENDE EVENT :: MEMBER
 *=======================================================*/
function attend_event(id, name)
 {
    $('[name="member_id"]').val(id); 
    $('[name="member_name"]').val(name); 
    $("#attend_EventModal").modal('show');
    $(".modal-title").text('Enroll Member to Event');
    $(".sbtn").text('Save');
 }

 function edit_enroll(id)
 {
    $('#edit_AttendEventModal').modal('show');

    $.ajax({
        url:  base_url + 'administrator/single-event/enroll/edit/'+ id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {
            $('[name="id"]').val(data.id);
            $('[name="event_id"]').val(data.event_id);
            $('[name="member_id"]').val(data.member_id);
            $('[name="payment_status"]').val(data.payment_status);
            $('[name="approval_status"]').val(data.approval_status);
            $('[name = "check_in_status"]').val(data.check_in_status);

            //load modal
            start_load()
            $("#edit_AttendEventModal").modal('show');
            $(".modal-title").text("Update Enroll Status!");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
        },500)
        }
    });
}
function delete_enroll(id, name)
{
  var confirmation = confirm('Are you sure you want to Unroll the ' + name + ' ?');
  if (confirmation) {
      window.location.href = base_url + '/administrator/single-event/enroll/delete/' + id;
  }
}



/** ======================================================
* MEMBER Settings - Membership Types
*=========================================================*/

function add_mtype()
 {
    $("#member_typeModal").modal('show');
    $(".modal-title").text('Add Memberhip Type');
    $(".sbtn").text('Save');
 }
 function edit_mtype(id)
 {
    $('#member_typeModal').modal('show');

    $.ajax({
        type:   "GET",
        url:    base_url + 'administrator/members/settings/member-type/edit/' + id,
        dataType: "JSON",
        success: function(data){
            $('[name="id"]').val(data.id);
            $('[name="name"]').val(data.name);
            $('[name="icon"]').val(data.icon);
            $('[name="description"]').val(data.description);

            if(data.photo !== null){
                $("#display-image").html("<img src="+data.photo+" style='width:40px;height:40px;object-fit:cover'>");
            }

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/members/settings/member-type/update");

            //load modal
            start_load()
            $("#member_typeModal").modal('show');
            $(".modal-title").text("Edit Memberhip Type");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
            },500)
        }
    });
 }

function delete_mtype(id, name)
{
    var confirmation = confirm('Are you sure want to delete this Membership Type? '+name);
    if(confirmation == true){
      window.location.href = base_url + ('administrator/members/settings/member-type/delete/')+ id;
    }
}

/** ====================================
 *  Professional Levels Settings
 =======================================*/
 function add_proLevel()
 {
    $("#professional_levelsModal").modal('show');
    $(".modal-title").text('Add Professional Level');
    $(".sbtn").text('Save');
 }
 function edit_proLevel(id)
 {
    $('#professional_levelsModal').modal('show');

    $.ajax({
        type:   "GET",
        url:    base_url + 'administrator/members/settings/pro-level/edit/' + id,
        dataType: "JSON",
        success: function(data){
            $('[name="id"]').val(data.id);
            $('[name="name"]').val(data.name);
            $('[name="icon"]').val(data.icon);
            $('[name="description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/members/settings/pro-level/update");

            //load modal
            start_load()
            $("#professional_levelsModal").modal('show');
            $(".modal-title").text("Edit Professional Level");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
            },500)
        }
    });
 }

function delete_proLevel(id, name)
{
    var confirmation = confirm('Are you sure want to delete this Membership Type? '+name);
    if(confirmation == true){
      window.location.href = base_url + ('administrator/members/pro-level/delete/')+ id;
    }
}

/** ====================================
 *  Registration Types Settings
 =======================================*/
 function add_regtype()
 {
    $("#registration_TypesModal").modal('show');
    $(".modal-title").text('Add Registration Types');
    $(".sbtn").text('Save');
 }
 function edit_regtype(id)
 {
    $('#registration_TypesModal').modal('show');

    $.ajax({
        type:   "GET",
        url:    base_url + 'administrator/members/settings/reg-type/edit/' + id,
        dataType: "JSON",
        success: function(data){
            $('[name="id"]').val(data.id);
            $('[name="name"]').val(data.name);
            $('[name="icon"]').val(data.icon);
            $('[name="description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/members/settings/reg-type/update");

            //load modal
            start_load()
            $("#registration_TypesModal").modal('show');
            $(".modal-title").text("Edit Registration Type");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
            },500)
        }
    });
 }

function delete_regtype(id, name)
{
    var confirmation = confirm('Are you sure want to delete this Registration Type? '+name);
    if(confirmation == true){
      window.location.href = base_url + ('administrator/members/settings/reg-type/delete/')+ id;
    }
}

/** ====================================
 *  Member Subscription Plans
 =======================================*/
 function add_plan()
 {
    $("#subPlanModal").modal('show');
    $(".modal-title").text('Add Subscription Plans');
    $(".sbtn").text('Save');
 }
 function edit_plan(id)
 {
    $('#subPlanModal').modal('show');

    $.ajax({
        type:   "GET",
        url:    base_url + 'administrator/members/settings/subscription-plan/edit/' + id,
        dataType: "JSON",
        success: function(data){
            $('[name="id"]').val(data.id);
            $('[name="name"]').val(data.name);
            $('[name="currency_id"]').val(data.currency_id);
            $('[name="duration_type"]').val(data.duration_type);
            $('[name="tax_rate"]').val(data.tax_rate);
            $('[name="amount"]').val(data.amount);
            $('[name="description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/members/settings/subscription-plan/update");

            //load modal
            start_load()
            $("#subPlanModal").modal('show');
            $(".modal-title").text("Edit Subscription Plan");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
            },500)
        }
    });
 }

function delete_plan(id, name)
{
    var confirmation = confirm('Are you sure want to delete this Subscription Plan? '+name);
    if(confirmation == true){
      window.location.href = base_url + ('administrator/members/settings/subscription-plan/delete/')+ id;
    }
}

/** ====================================
 *  Member Status
 =======================================*/
 function add_mstatus()
 {
    $("#memberStatusModal").modal('show');
    $(".modal-title").text('Add Member Status');
    $(".sbtn").text('Save');
 }
 function edit_mstatus(id)
 {
    $('#memberStatusModal').modal('show');

    $.ajax({
        type:   "GET",
        url:    base_url + 'administrator/members/settings/status/edit/' + id,
        dataType: "JSON",
        success: function(data){
            $('[name="id"]').val(data.id);
            $('[name="name"]').val(data.name);
            $('[name="color"]').val(data.color);
            $('[name="icon"]').val(data.icon);
            $('[name="description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/members/settings/status/update");

            //load modal
            start_load()
            $("#memberStatusModal").modal('show');
            $(".modal-title").text("Edit Member Status");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
            },500)
        }
    });
 }

function delete_mstatus(id, name)
{
    var confirmation = confirm('Are you sure want to delete this Status? '+name);
    if(confirmation == true){
      window.location.href = base_url + ('administrator/members/settings/status/delete/')+ id;
    }
}