/**
 * This jQuery file contains functions for Customer Settings
 * in ACB Member Management system
 * Developed by LWEGATECH - www.lwegatech.com
 **/

var save_method;

/** ================================================
 *  Events LIST
 *===================================================*/
var table_events;
$(document).ready( function () {
  start_load()
  $(document).on('click', '[data-bs-toggle="popover"]', function () {
       $(this).popover();
   });
  table_events = $('#event-list').DataTable( {
  dom: 'Blfrtip',
    buttons: [
        'copy', 'csv', 'excel', 'pdf', 'print'
      ],
  "processing": true,
    "serverSide": true,
    "ajax": {
        "url": base_url + "administrator/events/list",
        "type": "GET",
        "data": function (d) {

            d.search = { "value": $('#event-list_filter input').val() };
        }
    },
  "columns": [
        {"data": "id"},
        {"data": "event_year"},
        {
            "orderable":      true,
            "data":           null,
            render: function ( data, type, row ) {
            return '<a href="'+ base_url+"administrator/single-event/id="+data["id"] +'" class="text-dark"><strong>' + data["event_name"] + '</strong></a>'; 
            }
        },
        {"data": "category_name"},
        {
            "orderable":      true,
            "data":           null,
            render: function ( data, type, row ) {
            return '' + dateToNFT(new Date(data["start_date"])) + ''; 
            }
        },
        {
            "orderable":      true,
            "data":           null,
            render: function ( data, type, row ) {
            return '' + dateToNFT(new Date(data["end_date"])) + ''; 
            }
        },
        {"data": "event_location"},
        {
            "orderable":      false,
            "data":           null,
            render: function ( data, type, row ) {
                return ' '+data["total_attendees"]+'';   
            }
        },
        {
            "orderable":      true,
            "data":           null,
            render: function ( data, type, row ) {
                return '' + parseFloat(data["total_amount"]).toLocaleString("en-US",{style:'decimal',minimumFractionDigits:0,maximumFractionDigits:0}) + '';   
            }
        },
        { 
            "orderable":      false,
            "data":           null,
            render: function ( data, type, row ) {
                if( data["status"] == 'upcoming'){
                    return '<span class="badge bg-primary bg-opacity-75" style="font-size:9px;">UPCOMING</span>';
                }else if( data["status"] == 'ongoing'){
                    return '<span class="badge bg-warning bg-opacity-75" style="font-size:9px;">ONGOING</span>';
                }else if( data["status"] == 'completed'){
                    return '<span class="badge badge bg-success bg-opacity-75" style="font-size:9px;">COMPLETED </span>';
                }else{
                    return '<span class="badge badge bg-danger bg-opacity-75">CANCELLED</span>';
                }
            }
        },
       {
           "orderable":      false,
           "data":           null,
           render:function(data, type, row)
           {
               var btn ='<div class="dropdown">'+
                        '<button class="btn btn-light" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">'+
                        '<i class="bi bi-three-dots-vertical"></i>'+
                        '</button>'+
                        '<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">'+
                        '<li><a class="dropdown-item" title="Edit" onclick="edit_event('+data["id"]+')\" style="cursor: pointer"><small>Edit</small></a></li>'+
                        '<li><a class="dropdown-item" href="'+base_url+'administrator/single-event/id='+data["id"]+'"><small>View</small></a></li>'+
                        '<li><a class="dropdown-item" onclick="add_eventSession('+data["id"]+',\''+data["event_name"]+'\')\" style="cursor: pointer"><small>Add Session</small></a></li>'+
                        '<li><a class="dropdown-item" onclick="add_eventFee('+data["id"]+',\''+data["event_name"]+'\')\" style="cursor: pointer"><small>Add Fee</small></a></li>'+
                        '<li><a class="dropdown-item" onclick="delete_event('+data["id"]+',\''+data["event_name"]+'\')\" style="cursor: pointer"><small>Delete</small></a></li>'+
                        ' </ul>'+
                        '</div>';
                    return btn;
           }
       }
  ],
  "order": [[0, 'desc']],
  });
  setTimeout(function(){
   end_load()
   
},500)
});

//Edit Event
function edit_event(id)
{
    $('#event_Modal').modal('show');

    $.ajax({
        url:  base_url + 'administrator/single-event/edit='+ id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {
            $('[name="id"]').val(data.id);
            $('[name="event_name"]').val(data.event_name);
            $('[name="category_id"]').val(data.category_id);
            $('[name="event_year"]').val(data.event_year);
            $('[name="event_theme"]').val(data.event_theme);
            $('[name="event_location"]').val(data.event_location);
            $('[name = "start_date"]').val(dateToYMDinBootstrap(new Date(data.start_date)));
            $('[name = "end_date"]').val(dateToYMDinBootstrap(new Date(data.end_date)));
            $('[name = "event_objectives"]').val(data.event_objectives);
            $('[name = "description"]').val(data.description);
            $('[name = "status"]').val(data.status);            

            if(data.photo !== null){
                $("#preview-image").html("<img src="+data.photo+" width='50px;height:50px'>");
            }

            //load modal
            start_load()
            $("#event_Modal").modal('show');
            $(".modal-title").text("Edit & Update Event!");
            $(".sbtn").text("Update Event");
            setTimeout(function(){
            end_load();
        },500)
        }
    });
}
function delete_event(id, name)
{
  var confirmation = confirm('Are you sure you want to delete ' + name + ' Event?');
  if (confirmation) {
      window.location.href = base_url + '/administrator/single-event/delete/' + id;
  }
}

/** =====================================================
 * FEES
 *=======================================================*/
function add_eventFee(id, name)
 {
    $('[name="event_id"]').val(id); 
    $('[name="event_name"]').val(name); 
    $("#fee_EventModal").modal('show');
    $(".modal-title").text('Add Event Fee');
    $(".sbtn").text('Save');
 }
function edit_eventFee(id, ename)
{
    $('#fee_EventModal').modal('show');

    $.ajax({
        url:  base_url + 'administrator/single-event/fee/edit='+ id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {
            $('[name="event_name"]').val(ename); 
            $('[name="id"]').val(data.id);
            $('[name="event_id"]').val(data.event_id);
            $('[name="registration_type_id"]').val(data.registration_type_id);
            $('[name="membership_type_id"]').val(data.membership_type_id);
            $('[name="amount"]').val(data.amount);
            $('[name = "currency_id"]').val(data.currency);
            $('[name = "description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/single-event/fee/update");

            //load modal
            start_load()
            $("#fee_EventModal").modal('show');
            $(".modal-title").text("Update Event Fee!");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
        },500)
        }
    });
}
function delete_eventFee(id, name)
{
  var confirmation = confirm('Are you sure you want to delete Event Fee?');
  if (confirmation) {
      window.location.href = base_url + '/administrator/single-event/fee/delete/' + id;
  }
}


/** =====================================================
 * SESSION
 *=======================================================*/
function add_eventSession(id, name)
{
   $('[name="event_id"]').val(id); 
   $('[name="event_name"]').val(name); 
    $("#session_EventModal").modal('show');
    $(".modal-title").text('Add Event Session');
    $(".sbtn").text('Save');
 }
function edit_eventSession(id, ename)
{
    $('#session_EventModal').modal('show');

    $.ajax({
        url:  base_url + 'administrator/single-event/session/edit='+ id,
        type: "GET",
        dataType: "JSON",
        success: function(data)
        {
            $('[name="event_name"]').val(ename); 
            $('[name="id"]').val(data.id);
            $('[name="event_id"]').val(data.event_id);
            $('[name="session_title"]').val(data.session_title);
            $('[name = "session_date"]').val(dateToYMDinBootstrap(new Date(data.session_date)))
            $('[name="speaker_id"]').val(data.speaker_id);
            $('[name = "start_time"]').val(data.start_time);
            $('[name = "end_time"]').val(data.end_time);
            $('[name = "description"]').val(data.description);

            // Change form action to update URL
            $("form").attr("action", base_url + "administrator/single-event/session/update");

            //load modal
            start_load()
            $("#session_EventModal").modal('show');
            $(".modal-title").text("Update Event session!");
            $(".sbtn").text("Update");
            setTimeout(function(){
            end_load();
        },500)
        }
    });
}
function delete_eventSession(id, name)
{
  var confirmation = confirm('Are you sure you want to delete Event session?');
  if (confirmation) {
      window.location.href = base_url + '/administrator/single-event/session/delete/' + id;
  }
}

/** =====================================================
 * Speaker
 *=======================================================*/
    function add_eventSpeaker(id, name)
    {
         $("#speaker_EventModal").modal('show');
        $('[name="event_id"]').val(id); 
        $('[name="event_name"]').val(name); 
        
        $(".modal-title").text('Add Event Speaker');
        $(".sbtn").text('Save');
    }
    
    function edit_eventSpeaker(id, ename)
    {
        $('#speaker_EventModal').modal('show');
    
        $.ajax({
            url:  base_url + 'administrator/single-event/speaker/edit='+ id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                $('[name="event_name"]').val(ename); 
                $('[name="id"]').val(data.id);
                $('[name="event_id"]').val(data.event_id);
                $('[name="name"]').val(data.name);
                $('[name = "email"]').val(data.email);
                $('[name = "phone"]').val(data.phone);
                 $('[name = "position"]').val(data.position);
                $('[name = "organization"]').val(data.organization);
                $('[name = "bio"]').val(data.bio);
    
                if(data.photo !== null){
                    $("#preview-image").html("<img src="+data.photo+" width='50px;height:50px'>");
                }
                
                // Change form action to update URL
                $("form").attr("action", base_url + "administrator/single-event/speaker/update");
    
                //load modal
                start_load()
                $("#speaker_EventModal").modal('show');
                $(".modal-title").text("Update Event Speaker!");
                $(".sbtn").text("Update");
                setTimeout(function(){
                end_load();
            },500)
            }
        });
    }
    
    function delete_eventSpeaker(id, name)
    {
      var confirmation = confirm('Are you sure you want to delete Speaker '+name +'?');
      if (confirmation) {
          window.location.href = base_url + 'administrator/single-event/speaker/delete/' + id;
      }
    }
    
/** =====================================================
 * ATTENDE EVENT :: MEMBER
 *=======================================================*/
    function attend_event(id, name)
     {
        $('[name="event_id"]').val(id); 
        $('[name="event_name"]').val(name); 
        $("#attendEventModal").modal('show');
        $(".modal-title").text('Enroll Member to Event');
        $(".sbtn").text('Save');
     }
    
     function edit_enroll(id)
     {
        $('#edit_AttendEventModal').modal('show');
    
        $.ajax({
            url:  base_url + 'administrator/single-event/enroll/edit/'+ id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                $('[name="id"]').val(data.id);
                $('[name="event_id"]').val(data.event_id);
                $('[name="member_id"]').val(data.member_id);
                $('[name="payment_status"]').val(data.payment_status);
                $('[name="approval_status"]').val(data.approval_status);
                $('[name = "check_in_status"]').val(data.check_in_status);
    
                //load modal
                start_load()
                $("#edit_AttendEventModal").modal('show');
                $(".modal-title").text("Update Enroll Status!");
                $(".sbtn").text("Update");
                setTimeout(function(){
                end_load();
            },500)
            }
        });
    }
    function delete_enroll(id, name)
    {
      var confirmation = confirm('Are you sure you want to Unroll the ' + name + ' ?');
      if (confirmation) {
          window.location.href = base_url + '/administrator/single-event/enroll/delete/' + id;
      }
    }

/** =====================================================
 * Speaker
 *=======================================================*/
    function add_eventSponsor(id, name)
    {
         $("#sponsor_EventModal").modal('show');
        $('[name="event_id"]').val(id); 
        $('[name="event_name"]').val(name); 
        
        $(".modal-title").text('Add Event Sponsor');
        $(".sbtn").text('Save');
    }
    
    function edit_eventSponsor(id, ename)
    {
        $('#sponsor_EventModal').modal('show');
    
        $.ajax({
            url:  base_url + 'administrator/single-event/sponsor/edit='+ id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                $('[name="event_name"]').val(ename); 
                $('[name="id"]').val(data.id);
                $('[name="event_id"]').val(data.event_id);
                $('[name = "organization"]').val(data.organization);
                $('[name="sponsorship_level_id"]').val(data.sponsorship_level_id);
                $('[name = "email"]').val(data.email);
                $('[name = "phone"]').val(data.phone);
                 $('[name = "contact_person"]').val(data.contact_person);
                 $('[name = "contact_email"]').val(data.contact_email);
                $('[name = "contact_phone"]').val(data.contact_phone);
                $('[name = "description"]').val(data.description);
    
                if(data.photo !== null){
                    $("#preview-image").html("<img src="+data.photo+" width='50px;height:50px'>");
                }
                
                // Change form action to update URL
                $("form").attr("action", base_url + "administrator/single-event/sponsor/update");
    
                //load modal
                start_load()
                $("#sponsor_EventModal").modal('show');
                $(".modal-title").text("Update Event Speaker!");
                $(".sbtn").text("Update");
                setTimeout(function(){
                end_load();
            },500)
            }
        });
    }
    
    function delete_eventSponsor(id, name)
    {
      var confirmation = confirm('Are you sure you want to delete Speaker '+name +'?');
      if (confirmation) {
          window.location.href = base_url + 'administrator/single-event/sponsor/delete/' + id;
      }
    }