/** ========================================================================
 * Pages and Categories - KEEPING ALL EXISTING FUNCTIONALITY
 * ========================================================================**/
function readImage(file) {
    var reader = new FileReader();
    var image = new Image();
    reader.readAsDataURL(file);
    reader.onload = function(_file) {
        image.src = _file.target.result;
        image.onload = function() {
            var w = this.width,
            h = this.height,
            t = file.type,
            n = file.name,
            s = file.size;
            if (file.size > 2097152) {
                toastr.error('Image too large: ' + file.size + '. Try less than 2MB!');
            } else {
                $('#postImgPreview').append('<img src="' + this.src + '" class="img-thumbnail thumb" style="height: 120px">');
            }
        };
        image.onerror = function() {
            toastr.error('Invalid file type: ' + file.type);
        };
    };
}

$("#post_image").change(function(e) {
    if (this.disabled) {
        toastr.error('Sorry! File upload not supported!');
    }
    let numOfFiles = 0;
    var F = this.files;
    if (F && F[0]) {
        if (numOfFiles + F.length > 4) {
            toastr.error('You can only upload at most 2 Images!');
        } else {
            for (var i = 0; i < F.length; i++) {
                readImage(F[i]);
            }
        }
    }
});

// Delete Page
function delete_post(id, name) {
    $("#delPageModal").modal('show');
    $("#pname").html(name);
    $("#postbtn").on('click', function() {
        $.ajax({
            url: base_url + "pages/delete/" + id,
            type: "POST",
            dataType: "JSON",
            headers: { 'X-Requested-With': 'XMLHttpRequest' },
            success: function(data) {
                $("#delPageModal").modal('hide');
                html = '<div class="alert alert-danger" role="alert">' + data.msg + '</div>';
                document.getElementById('showMsg').innerHTML = html;
                setTimeout(function() {
                    location.href = base_url + "/pages";
                }, 800);
            }
        });
    });
}

/**===============================================================
 * Edit/Update/Delete Menu Item - KEEPING EXISTING FUNCTIONS
 =================================================================*/
function edit_menu(id) {
    var form = $('#form-menu')[0].reset();
    $.ajax({
        url: base_url + 'administrator/menu/item/custom/edit/' + id,
        type: "GET",
        dataType: "JSON",
        success: function(data) {
            $('[name="id"]').val(data.id);
            $('[name="title"]').val(data.title);
            $('[name="menutype_id"]').val(data.menutype_id);
            $('[name="ordering"]').val(data.ordering);
            $('[name="description"]').val(data.description);
            $('[name="path"]').val(data.path);
            $('[name="url"]').val(data.url);
            $('[name="level"]').val(data.level);
            if (data.photo !== null) {
                $("#preview-image").html("<img src=" + data.photo + " width='80px'>");
            }

            $("#parent_id option:selected").text(data.parent_id);
            $("#parent_id option:selected").val(data.parent_name);

            start_load()
            $("#EditMenuModal").modal('show');
            $(".modal-title").text("Edit Menu Item!");
            $(".stbtn").text("Update");
        }
    });
}

function save_menu() {
    var form = $('#form-menu')[0];
    var formData = new FormData(form);

    $.ajax({
        type: "post",
        url: base_url + 'administrator/menu/item/custom/update',
        dataType: "JSON",
        data: formData,
        processData: false,
        contentType: false,
        headers: { 'X-Requested-With': 'XMLHttpRequest' },
        success: function(data) {
            if (data.success == true) {
                $('#EditMenuModal').modal('hide');
                toastr.success(data.msg);
                $('#EditMenuModal').reset;
            } else {
                toastr.error(data.msg);
            }
        }
    });
}

/** Delete Menu */
function delete_menuItem(id, name) {
    var confirmation = confirm('Are you sure you want to delete ' + name + '?');
    if (confirmation) {
        window.location.href = base_url + 'administrator/menu/item/delete/' + id;
    }
}

/** Delete Menu type */
function delete_menuType(id, name) {
    var confirmation = confirm('Are you sure you want to delete ' + name + '?');
    if (confirmation) {
        window.location.href = base_url + 'administrator/menu/group/delete/' + id;
    }
}

/** ========================================================================
 * ENHANCED DYNAMIC MENU FUNCTIONALITY - IMPROVED VERSION
 * ========================================================================**/

// Global base URL
const baseUrl = window.baseUrl || '';

class MenuManager {
    constructor() {
        this.init();
    }

    init() {
        this.setupEventListeners();
        this.initializeStatusToggle();
        this.loadInitialData();
    }

    setupEventListeners() {
        // Content type change handler - using both vanilla JS and jQuery for compatibility
        const menuTypeSelect = document.getElementById('menuType');
        if (menuTypeSelect) {
            menuTypeSelect.addEventListener('change', () => this.handleContentTypeChange());
        }

        // Menu category change handler
        const menuCategorySelect = document.getElementById('menuCategory');
        if (menuCategorySelect) {
            menuCategorySelect.addEventListener('change', () => this.handleCategoryChange());
        }

        // Status toggle handler
        const statusToggle = document.getElementById('statusToggle');
        if (statusToggle) {
            statusToggle.addEventListener('change', () => this.toggleStatus());
        }

        // Custom link input change
        const customLinkInput = document.querySelector('input[name="custom"]');
        if (customLinkInput) {
            customLinkInput.addEventListener('input', () => this.updateCustomLink());
        }
    }

    initializeStatusToggle() {
        const statusToggle = document.getElementById('statusToggle');
        const statusValue = document.getElementById('statusValue');
        const statusText = document.getElementById('statusText');
        
        if (statusToggle && statusValue) {
            if (statusValue.value === '1' || statusValue.value === 1) {
                statusToggle.checked = true;
                if (statusText) statusText.textContent = 'Active';
            } else {
                statusToggle.checked = false;
                if (statusText) statusText.textContent = 'Inactive';
            }
        }
    }

    loadInitialData() {
        // Initialize content options if type is already selected
        const menuTypeSelect = document.getElementById('menuType');
        if (menuTypeSelect && menuTypeSelect.value) {
            this.handleContentTypeChange();
        }

        // Initialize parent menus if category is already selected
        const menuCategorySelect = document.getElementById('menuCategory');
        if (menuCategorySelect && menuCategorySelect.value) {
            this.handleCategoryChange();
        }
    }

    handleContentTypeChange() {
        const menuTypeSelect = document.getElementById('menuType');
        const contentType = menuTypeSelect ? menuTypeSelect.value : '';
        const contentOptions = document.getElementById('contentOptions');
        const customLinkOptions = document.getElementById('customLinkOptions');
        
        // Hide all options first
        if (contentOptions) contentOptions.style.display = 'none';
        if (customLinkOptions) customLinkOptions.style.display = 'none';
        
        if (contentType === 'custom') {
            if (customLinkOptions) {
                customLinkOptions.style.display = 'block';
                this.updateCustomLink();
            }
        } else if (contentType) {
            if (contentOptions) {
                contentOptions.style.display = 'block';
                this.loadContentOptions(contentType);
            }
        } else {
            this.updateMenuLink('');
        }
    }

    handleCategoryChange() {
        const menuCategorySelect = document.getElementById('menuCategory');
        const categoryId = menuCategorySelect ? menuCategorySelect.value : '';
        
        if (categoryId) {
            this.loadParentMenus(categoryId);
        } else {
            // Clear parent menu if no category selected
            const parentSelect = document.getElementById('parentMenu');
            if (parentSelect) {
                parentSelect.innerHTML = '<option value="">Select Parent</option>';
            }
        }
    }

    async loadContentOptions(contentType) {
        try {
            this.showLoading('contentDropdown');
            
            const response = await fetch(`${baseUrl}administrator/menu/getContentByType?content_type=${contentType}`);
            const data = await response.json();
            
            this.updateContentDropdown(data, contentType);
        } catch (error) {
            console.error('Error loading content:', error);
            this.showError('contentDropdown', 'Error loading content options');
        }
    }

    async loadParentMenus(categoryId) {
        try {
            this.showLoading('parentMenu');
            
            const response = await fetch(`${baseUrl}administrator/menu/getMenusByCategory?category_id=${categoryId}`);
            const data = await response.json();
            
            this.updateParentDropdown(data);
        } catch (error) {
            console.error('Error loading parent menus:', error);
            this.showError('parentMenu', 'Error loading parent menus');
        }
    }

    updateContentDropdown(data, contentType) {
        const dropdown = document.getElementById('contentDropdown');
        if (!dropdown) return;

        let html = '';
        
        if (data && data.length > 0) {
            // Determine field name based on content type
            let fieldName = 'page_id';
            let placeholder = 'Select content';
            
            switch(contentType) {
                case 'page':
                case 'post': 
                case 'service':
                    fieldName = contentType + '_id';
                    placeholder = `Select ${contentType}`;
                    break;
                case 'category':
                    fieldName = 'post_category';
                    placeholder = 'Select category';
                    break;
                default:
                    fieldName = 'post_id';
                    placeholder = `Select ${contentType}`;
            }
            
            html = `<select class="form-select" name="${fieldName}" id="contentSelect">
                <option value="">${placeholder}</option>`;
            
            data.forEach(item => {
                const link = item.menu_link || item.alias || item.slug || '';
                const title = item.title || item.name || 'Untitled';
                html += `<option value="${item.id}" data-link="${link}">${title}</option>`;
            });
            
            html += '</select>';
            
            dropdown.innerHTML = html;
            
            // Add change listener to the new select
            const contentSelect = document.getElementById('contentSelect');
            if (contentSelect) {
                contentSelect.addEventListener('change', (e) => {
                    const selectedOption = e.target.options[e.target.selectedIndex];
                    const link = selectedOption.getAttribute('data-link');
                    this.updateMenuLink(link);
                });

                // Pre-select content if menuItemData is available (for edit mode)
                if (window.menuItemData && window.menuItemData.menu_type === contentType) {
                    let selectedContentId = null;
                    if (contentType === 'category') {
                        selectedContentId = window.menuItemData.post_cat;
                    } else {
                        selectedContentId = window.menuItemData.post_id;
                    }

                    if (selectedContentId) {
                        contentSelect.value = selectedContentId;
                        // Trigger change to update menu link preview
                        contentSelect.dispatchEvent(new Event('change'));
                    }
                }
            }
        } else {
            html = '<p class="text-muted">No content available for this type</p>';
            dropdown.innerHTML = html;
        }
    }

    updateParentDropdown(data) {
        const parentSelect = document.getElementById('parentMenu');
        if (!parentSelect) return;

        let html = '<option value="">Select Parent</option>';
        
        if (data && data.length > 0) {
            data.forEach(menu => {
                html += `<option value="${menu.id}">${menu.title} (Level ${menu.level})</option>`;
            });
        }
        
        parentSelect.innerHTML = html;

        // Pre-select parent menu if menuItemData is available (for edit mode)
        if (window.menuItemData && window.menuItemData.parent_id) {
            parentSelect.value = window.menuItemData.parent_id;
        }
    }

    updateCustomLink() {
        const customLinkInput = document.querySelector('input[name="custom"]');
        if (customLinkInput) {
            this.updateMenuLink(customLinkInput.value);
        }
    }

    updateMenuLink(link) {
        const linkPreview = document.getElementById('menu_link_preview');
        if (linkPreview) {
            linkPreview.value = link || '';
        }
    }

    toggleStatus() {
        const statusToggle = document.getElementById('statusToggle');
        const statusText = document.getElementById('statusText');
        const statusValue = document.getElementById('statusValue');
        
        if (statusToggle && statusText && statusValue) {
            if (statusToggle.checked) {
                statusText.textContent = 'Active';
                statusValue.value = '1';
            } else {
                statusText.textContent = 'Inactive';
                statusValue.value = '0';
            }
        }
    }

    showLoading(elementId) {
        const element = document.getElementById(elementId);
        if (element) {
            element.innerHTML = '<div class="text-center"><div class="spinner-border spinner-border-sm" role="status"></div> Loading...</div>';
        }
    }

    showError(elementId, message) {
        const element = document.getElementById(elementId);
        if (element) {
            element.innerHTML = `<p class="text-danger">${message}</p>`;
        }
    }
}

// ==================== JQUERY COMPATIBILITY FUNCTIONS ====================

/** Dynamic content loading based on content type - jQuery version */
function loadContentByType(contentType) {
    if (!contentType) return;

    $.ajax({
        url: base_url + 'administrator/menu/getContentByType',
        type: 'GET',
        data: { content_type: contentType },
        dataType: 'json',
        success: function(response) {
            updateContentDropdown(response, contentType);
        },
        error: function() {
            toastr.error('Error loading content');
        }
    });
}

/** Update parent menus based on category - jQuery version */
function updateParentMenus(categoryId) {
    if (!categoryId) return;

    $.ajax({
        url: base_url + 'administrator/menu/getMenusByCategory',
        type: 'GET',
        data: { category_id: categoryId },
        dataType: 'json',
        success: function(response) {
            const parentSelect = $('#parentMenu');
            parentSelect.empty().append('<option value="">Select Parent</option>');

            $.each(response, function(index, menu) {
                parentSelect.append(`<option value="${menu.id}">${menu.title} (Level ${menu.level})</option>`);
            });
        }
    });
}

/** Update menu link preview - jQuery version */
function updateMenuLink(link) {
    $('#menu_link_preview').val(link || '');
}

/** Toggle status switch - jQuery version */
function setupStatusToggle() {
    $('#statusToggle').change(function() {
        const statusText = $('#statusText');
        const statusValue = $('#statusValue');

        if ($(this).is(':checked')) {
            statusText.text('Active');
            statusValue.val(1);
        } else {
            statusText.text('Inactive');
            statusValue.val(0);
        }
    });
}

/** Update content dropdown based on response - jQuery version */
function updateContentDropdown(data, contentType) {
    const dropdown = $('#contentDropdown');
    let html = '';

    if (data.length > 0) {
        // Determine field name based on content type
        let fieldName = 'page_id'; // default
        let placeholder = 'Select content';

        switch (contentType) {
            case 'page':
            case 'post':
            case 'service':
                fieldName = contentType + '_id';
                placeholder = `Select ${contentType}`;
                break;
            case 'category':
                fieldName = 'post_category';
                placeholder = 'Select category';
                break;
            default:
                // For custom content types from database
                fieldName = 'post_id';
                placeholder = `Select ${contentType}`;
        }

        html = `<select class="form-select" name="${fieldName}" id="contentSelect">
            <option value="">${placeholder}</option>`;

        $.each(data, function(index, item) {
            const link = item.menu_link || item.alias || '';
            html += `<option value="${item.id}" data-link="${link}">${item.title}</option>`;
        });

        html += '</select>';
    } else {
        html = '<p class="text-muted">No content available for this type</p>';
    }

    dropdown.html(html);

    // Add change listener to the new select
    const contentSelect = $('#contentSelect');
    if (contentSelect.length) {
        contentSelect.off('change').on('change', function() {
            const selectedOption = $(this).find('option:selected');
            const link = selectedOption.data('link');
            updateMenuLink(link);
        });
    }
}

// ==================== DOCUMENT READY INITIALIZATION ====================

$(document).ready(function() {
    // DataTable initialization for menu lists
    if ($('#menu-list').length) {
        $('#menu-list').DataTable();
    }

    if ($('#catlist').length) {
        $('#catlist').DataTable({
            pageLength: 10,
            order: [
                [0, "Desc"]
            ],
        });
    }

    // Initialize the new MenuManager for modern menu forms
    if (document.getElementById('menuType') || document.getElementById('menuForm')) {
        window.menuManager = new MenuManager();
    }

    // jQuery compatibility initialization for legacy code
    if ($('#menuType').length || $('#menuForm').length) {
        setupStatusToggle();

        // Content type change handler - jQuery
        $('#menuType').change(function() {
            const contentType = $(this).val();
            $('#contentOptions').hide();
            $('#customLinkOptions').hide();

            if (contentType === 'custom') {
                $('#customLinkOptions').show();
                updateMenuLink($('input[name="custom"]').val());
            } else if (contentType) {
                $('#contentOptions').show();
                loadContentByType(contentType);
            } else {
                updateMenuLink('');
            }
        });

        // Menu category change handler - jQuery
        $('#menuCategory').change(function() {
            updateParentMenus($(this).val());
        });

        // Custom link input change - jQuery
        $('input[name="custom"]').on('input', function() {
            if ($('#menuType').val() === 'custom') {
                updateMenuLink($(this).val());
            }
        });

        // Initialize content options visibility
        const currentContentType = $('#menuType').val();
        if (currentContentType === 'custom') {
            $('#customLinkOptions').show();
            updateMenuLink($('input[name="custom"]').val());
        } else if (currentContentType) {
            $('#contentOptions').show();
            // Load content for current type if already selected
            loadContentByType(currentContentType);
        }

        // Initialize parent menus if category is selected
        const currentCategory = $('#menuCategory').val();
        if (currentCategory) {
            updateParentMenus(currentCategory);
        }

        // Initialize menu link if content is already selected
        const contentSelect = $('#contentSelect');
        if (contentSelect.length && contentSelect.val()) {
            const selectedOption = contentSelect.find('option:selected');
            const link = selectedOption.data('link');
            updateMenuLink(link);
        }
    }

    // Handle edit menu page initialization for legacy forms
    if ($('#pageid').length) {
        $('#pageid').change(function() {
            const selectedOption = $(this).find('option:selected');
            const link = selectedOption.data('link');
            if (link) {
                $('input[name="link"]').val(link);
            }
        });

        // Initialize link if page is already selected
        const selectedPage = $('#pageid').find('option:selected');
        if (selectedPage.length && selectedPage.data('link')) {
            $('input[name="link"]').val(selectedPage.data('link'));
        }
    }

    // Handle edit menu for other content types
    if ($('#catid').length) {
        $('#catid').change(function() {
            // You can add logic here to generate post links if needed
        });
    }
});

// Global functions for inline event handlers
window.delete_menuItem = delete_menuItem;
window.delete_menuType = delete_menuType;
window.edit_menu = edit_menu;
window.save_menu = save_menu;
window.delete_post = delete_post;

// Make MenuManager available globally
window.MenuManager = MenuManager;