/** ========================================================================
 * Jobs Management
 * ========================================================================**/

// Delete Job function
function delete_job(id, name) {
  var confirmation = confirm(
    "Are you sure you want to delete the job: " + name + "?"
  );
  if (confirmation == true) {
    window.location.href = base_url + "administrator/jobs/delete/" + id;
  }
}

// Delete Category function
function delete_category(id, name) {
  var confirmation = confirm(
    "Are you sure you want to delete the category: " + name + "?"
  );
  if (confirmation == true) {
    window.location.href =
      base_url + "administrator/jobs/categories/delete/" + id;
  }
}

// Image preview function
function readImage(file) {
  var reader = new FileReader();
  var image = new Image();
  reader.readAsDataURL(file);
  reader.onload = function (_file) {
    image.src = _file.target.result;
    image.onload = function () {
      var s = file.size;
      if (file.size > 2097152) {
        toastr.error("Image too large: " + file.size + ". Try less than 2MB!");
      } else {
        $("#postImgPreview").append(
          '<img src="' +
            this.src +
            '" class="img-thumbnail thumb" style="height: 120px">'
        );
      }
    };
    image.onerror = function () {
      toastr.error("Invalid file type: " + file.type);
    };
  };
}

$("#post_image").change(function (e) {
  if (this.disabled) {
    toastr.error("File upload not supported!");
    return;
  }

  $("#postImgPreview").empty();
  let numOfFiles = 0;
  var F = this.files;

  if (F && F[0]) {
    if (numOfFiles + F.length > 4) {
      toastr.error("You can only upload at most 4 images!");
    } else {
      for (var i = 0; i < F.length; i++) {
        readImage(F[i]);
      }
    }
  }
});
