/**
 * Auto selection of State and City from  respective Countries
 */
 $(document).ready(function(){
    

    // City change
    $('#country_id').change(function(){
      var country_id = $(this).val();
      $.ajax({
        url: base_url+'state/'+country_id,
        method: 'post',
        data: {
          csrf_token_name: csrfToken,
          country_id: country_id
        },
        dataType: 'json',
        success: function(response){

          // Remove options       
          $('#state_id').find('option').not(':first').remove();
          $('#city_id').find('option').not(':first').remove();

          // Add options
          $.each(response,function(index,data){
             $('#state_id').append('<option value="'+data['id']+'">'+data['name']+'</option>');
          });
        }
     });
   });
 
   // City change
   $('#state_id').change(function(){
     var state_id = $(this).val();
     
     // AJAX request for State -> City dropdown
    $.ajax({
      url: base_url + 'city/' + state_id,
      method: 'post',
      data: {
        csrf_token_name: csrfToken, // Reuse the same CSRF token
        state_id: state_id
      },
      dataType: 'json',
      success: function (response) {
         // Remove options
         $('#city_id').find('option').not(':first').remove();

         // Add options
         $.each(response,function(index,data){
           $('#city_id').append('<option value="'+data['id']+'">'+data['name']+'</option>');
         });
       }
    });
  });
 
 });