<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Banking Section -->
<section class="banking-section" id="branches">
    <div class="container">
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['branches_title'] ?? 'Our Branch Network',
            $templateData['branches_title_emphasized'] ?? 'Branch Network'
        ) ?></h2>
        
        <div class="branch-network">
            <!-- Branches List -->
            <?php if(!empty($templateData['branches'])): ?>
            <div class="branch-list">
                <?php foreach($templateData['branches'] as $index => $branch): ?>
                <div class="branch-item" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 + 300 ?>">
                    <div class="branch-info">
                        <h3><?= esc($branch['title']) ?></h3>
                        <?php if(!empty($branch['address'])): ?>
                            <p><i class="fas fa-map-marker-alt"></i> <?= esc($branch['address']) ?></p>
                        <?php endif; ?>
                        <?php if(!empty($branch['phone'])): ?>
                            <p><i class="fas fa-phone"></i> <?= esc($branch['phone']) ?></p>
                        <?php endif; ?>
                        <?php if(!empty($branch['hours'])): ?>
                            <p><i class="fas fa-clock"></i> <?= esc($branch['hours']) ?></p>
                        <?php endif; ?>
                        <?php if(!empty($branch['description'])): ?>
                            <p class="branch-description"><?= esc($branch['description']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
            
            <!-- Banking Options -->
            <div class="banking-options">
                <h3 class="options-title"><?= $templateData['banking_options_title'] ?? 'Ways to Bank With Us' ?></h3>
                <div class="banking-methods">
                    <?php if(!empty($templateData['banking_methods'])): ?>
                        <?php foreach($templateData['banking_methods'] as $index => $method): ?>
                        <div class="banking-method" data-aos="fade-up" data-aos-delay="<?= ($index % 2) * 100 + 400 ?>">
                            <div class="method-icon">
                                <i class="<?= esc($method['icon'] ?? 'fas fa-star') ?>"></i>
                            </div>
                            <h4 class="method-title"><?= esc($method['title']) ?></h4>
                            <?php if(!empty($method['features'])): ?>
                            <ul class="method-features">
                                <?php foreach($method['features'] as $feature): ?>
                                <li><i class="fas fa-check-circle"></i> <?= esc($feature) ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <?php endif; ?>
                            <?php if(!empty($method['description'])): ?>
                                <p class="method-description"><?= esc($method['description']) ?></p>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Additional Content Sections -->
<?php if(isset($templateData['additional_sections'])): ?>
    <?php foreach($templateData['additional_sections'] as $section): ?>
    <section class="additional-section" id="<?= esc($section['id'] ?? '') ?>">
        <div class="container">
            <?php if(!empty($section['title'])): ?>
                <h2 class="section-title"><?= renderEmphasized(
                    $section['title'],
                    $section['title_emphasized'] ?? null
                ) ?></h2>
            <?php endif; ?>
            <?php if(!empty($section['content'])): ?>
                <div class="section-content">
                    <?= $section['content'] ?>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php endforeach; ?>
<?php endif; ?>

<?= $this->endSection(); ?>