<?= $this->extend('website/index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Dynamic Block System for Personal Banking Page -->
<?php if (!empty($page_blocks)): ?>
    <?php foreach ($page_blocks as $block): ?>
        
        <?php if ($block['block_type'] === 'overview'): ?>
        <!-- Overview Section with Side Image -->
        <section class="overview-section-image">
            <div class="container">
                <div class="side-image-layout">
                    <!-- Content Side -->
                    <div class="content-side">
                        <h2><?= renderEmphasized($block['heading'], $block['title_emphasized'] ?? '') ?></h2>
                        <p><?= esc($block['content']) ?></p>
                        
                        <?php if (!empty($block['items'])): ?>
                        <div class="info-cards-grid">
                            <?php foreach ($block['items'] as $item): ?>
                            <div class="info-card">
                                <div class="info-card-icon">
                                    <i class="<?= esc($item['icon']) ?>"></i>
                                </div>
                                <h3><?= esc($item['title']) ?></h3>
                                <p><?= esc($item['description']) ?></p>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Image Side - Dynamic -->
                    <div class="image-side">
                        <img src="<?= base_url('media/files/' . $block['photo']) ?>" alt="<?= esc($block['heading']) ?>">
                    </div>
                </div>
            </div>
        </section>
        
        <?php elseif ($block['block_type'] === 'info_cards'): ?>
        <!-- Banking Solutions Section -->
        <div class="join">
            <header>
                <h1><?= renderEmphasized($block['heading'], $block['title_emphasized'] ?? '') ?></h1>
                <p class="subtitle"><?= esc($block['subtitle']) ?></p>
            </header>
            
            <!-- Tab Navigation -->
            <div class="tabs-container">
                <div class="tabs">
                    <button class="tab-button active" data-category="current">
                        <i class="fas fa-credit-card"></i>
                        Current
                        <span class="notification-badge"><?= $current_count ?></span>
                    </button>
                    <button class="tab-button" data-category="savings">
                        <i class="fas fa-piggy-bank"></i>
                        Savings
                        <span class="notification-badge"><?= $savings_count ?></span>
                    </button>
                    <button class="tab-button" data-category="loans">
                        <i class="fas fa-hand-holding-usd"></i>
                        Loans
                        <span class="notification-badge"><?= $loans_count ?></span>
                    </button>
                    <button class="tab-button" data-category="investing">
                        <i class="fas fa-chart-line"></i>
                        Investing
                        <span class="notification-badge"><?= $investing_count ?></span>
                    </button>
                    <button class="tab-button" data-category="insurance">
                        <i class="fas fa-shield-alt"></i>
                        Insurance
                        <span class="notification-badge"><?= $insurance_count ?></span>
                    </button>
                </div>
            </div>
            
            <!-- Service Cards -->
            <?php if (!empty($block['items'])): ?>
                <!-- Current Accounts -->
                <div id="current-cards" class="category-cards active">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Current'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Savings Accounts -->
                <div id="savings-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Savings'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Loans -->
                <div id="loans-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Loans'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Investing -->
                <div id="investing-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Investing'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Insurance -->
                <div id="insurance-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Insurance'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
    <?php endforeach; ?>
<?php else: ?>
<!-- Fallback if no blocks found -->
<section class="hero-section">
    <img
        src="<?= base_url('assets/front_assets/images/bank1.jpg') ?>"
        alt="Personal Banking"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1>Personal <span>Accounts</span></h1>
        <p>Begin your financial journey with ABC Capital Bank. Choose from our range of Personal accounts designed to meet your banking needs.</p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>
