<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>

<?php endif; ?>

<!-- All Transfer Solutions Section -->
<section class="py-5 bg-light">
  <div class="container" style="max-width:800px;">
    <div class="row justify-content-center">
      <div class="col-lg-10">

        <!-- Section Header -->
        <div class="text-center mb-4">
          <h2 class="fw-bold">All Transfer Solutions</h2>
          <p class="text-muted">Secure, fast, and reliable ways to transfer money locally and internationally.</p>
        </div>

        <!-- Accordion -->
        <div class="accordion accordion-flush" id="transferSolutionsAccordion">

          <!-- Telegraphic Transfers (T/T) -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingTT">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTT" aria-expanded="false" aria-controls="collapseTT">
                Telegraphic Transfers (T/T)
              </button>
            </h2>
            <div id="collapseTT" class="accordion-collapse collapse" aria-labelledby="headingTT" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>ABC Bank is part of the SWIFT society for worldwide interbank and financial communication. Represented in 208 countries with over 8,300 financial institutions, we securely transfer funds globally. Ideal for corporate and high-priority transactions.</p>
              </div>
            </div>
          </div>

          <!-- Western Union -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingWU">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseWU" aria-expanded="false" aria-controls="collapseWU">
                Western Union
              </button>
            </h2>
            <div id="collapseWU" class="accordion-collapse collapse" aria-labelledby="headingWU" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>ABC Bank partners with Western Union® to enable sending money to over 320,000 agent locations worldwide. Services include money transfer, bill payments, and prepaid solutions.</p>
              </div>
            </div>
          </div>

          <!-- MoneyGram -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingMG">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseMG" aria-expanded="false" aria-controls="collapseMG">
                MoneyGram
              </button>
            </h2>
            <div id="collapseMG" class="accordion-collapse collapse" aria-labelledby="headingMG" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>MoneyGram allows secure money transfers to over 180 countries worldwide, even without a bank account.</p>
              </div>
            </div>
          </div>

          <!-- RTGS -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingRTGS">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRTGS" aria-expanded="false" aria-controls="collapseRTGS">
                RTGS
              </button>
            </h2>
            <div id="collapseRTGS" class="accordion-collapse collapse" aria-labelledby="headingRTGS" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>Real Time Gross Settlement: transfers occur in real-time on a gross basis without batch processing. Ideal for urgent interbank transactions.</p>
              </div>
            </div>
          </div>

          <!-- Airtel Money -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingAirtel">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAirtel" aria-expanded="false" aria-controls="collapseAirtel">
                Airtel Money
              </button>
            </h2>
            <div id="collapseAirtel" class="accordion-collapse collapse" aria-labelledby="headingAirtel" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>ABC Capital Bank is an Airtel Money Super Agent. Agents can access float or withdraw cash easily. Visit any branch to use this service.</p>
              </div>
            </div>
          </div>

          <!-- MTN Mobile Money -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingMtn">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseMtn" aria-expanded="false" aria-controls="collapseMtn">
                MTN Mobile Money
              </button>
            </h2>
            <div id="collapseMtn" class="accordion-collapse collapse" aria-labelledby="headingMtn" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>ABC Capital Bank is an MTN Mobile Money Super Agent. Agents can easily access float or withdraw cash. Visit any branch for this service.</p>
              </div>
            </div>
          </div>

          <!-- EFT -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingEFT">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEFT" aria-expanded="false" aria-controls="collapseEFT">
                EFT
              </button>
            </h2>
            <div id="collapseEFT" class="accordion-collapse collapse" aria-labelledby="headingEFT" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>Electronic Funds Transfer allows secure credit and debit transfers between accounts via the local clearing house. Typically processed within 24 hours.</p>
              </div>
            </div>
          </div>

          <!-- Direct Debit -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingDD">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseDD" aria-expanded="false" aria-controls="collapseDD">
                Direct Debit
              </button>
            </h2>
            <div id="collapseDD" class="accordion-collapse collapse" aria-labelledby="headingDD" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>Direct Debit allows collecting funds from another bank account. Ideal for recurring payments such as insurance or subscriptions.</p>
              </div>
            </div>
          </div>

          <!-- Bankers Cheque -->
          <div class="accordion-item mb-2 shadow-sm rounded">
            <h2 class="accordion-header" id="headingCheque">
              <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCheque" aria-expanded="false" aria-controls="collapseCheque">
                Bankers Cheque
              </button>
            </h2>
            <div id="collapseCheque" class="accordion-collapse collapse" aria-labelledby="headingCheque" data-bs-parent="#transferSolutionsAccordion">
              <div class="accordion-body">
                <p>Bankers Cheques are issued by the bank and guaranteed against available funds. Safe for secure transactions.</p>
              </div>
            </div>
          </div>

        </div>
        <!-- End Accordion -->

      </div>
    </div>
  </div>
</section>


<?= $this->endSection() ?>