<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img 
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>" 
        alt="<?= esc($hero_banner['name']) ?>" 
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<div class="join"> 
    <!-- Tab Navigation -->
    <div class="tabs-container">
        <div class="tabs">
            <button class="tab-button active" data-category="personal-loans">
                <i class="fas fa-user"></i> Personal Loans
                <span class="notification-badge"><?= count($personal_loans) ?></span>
            </button>
            <button class="tab-button" data-category="business-loans">
                <i class="fas fa-building"></i> Business Loans
                <span class="notification-badge"><?= count($business_loans) ?></span>
            </button>
        </div>
    </div>

    <!-- Personal Loans Cards -->
    <div id="personal-loans-cards" class="category-cards active">
        <div class="cards-container">
            <?php foreach ($personal_loans as $loan): ?>
            <div class="banking-card">
                <div class="card-image">
                    <img src="<?= !empty($loan['photo']) ? base_url('media/files/' . $loan['photo']) : 'https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?auto=format&fit=crop&w=1170&q=80' ?>" 
                         alt="<?= esc($loan['title']) ?>">
                    <div class="card-category">Personal Loan</div>
                    <div class="card-overlay">
                        <h3 class="card-title"><?= esc($loan['title']) ?></h3>
                        <a href="<?= site_url('personal/' . $loan['alias']) ?>" class="card-button">Learn More</a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            
            <?php if (empty($personal_loans)): ?>
                <div class="no-loans-message">
                    <p>No personal loan products available at the moment.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Business Loans Cards -->
    <div id="business-loans-cards" class="category-cards">
        <div class="cards-container">
            <?php foreach ($business_loans as $loan): ?>
            <div class="banking-card">
                <div class="card-image">
                    <img src="<?= !empty($loan['photo']) ? base_url('media/files/' . $loan['photo']) : 'https://images.unsplash.com/photo-1554224155-6726b3ff858f?auto=format&fit=crop&w=1011&q=80' ?>" 
                         alt="<?= esc($loan['title']) ?>">
                    <div class="card-category">Business Loan</div>
                    <div class="card-overlay">
                        <h3 class="card-title"><?= esc($loan['title']) ?></h3>
                        <a href="<?= site_url('business/' . $loan['alias']) ?>" class="card-button">Learn More</a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            
            <?php if (empty($business_loans)): ?>
                <div class="no-loans-message">
                    <p>No business loan products available at the moment.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab functionality
    const tabButtons = document.querySelectorAll('.tab-button');
    const categoryCards = document.querySelectorAll('.category-cards');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetCategory = this.getAttribute('data-category');
            
            // Update active tab
            tabButtons.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');
            
            // Show target category, hide others
            categoryCards.forEach(cards => {
                if (cards.id === targetCategory + '-cards') {
                    cards.classList.add('active');
                } else {
                    cards.classList.remove('active');
                }
            });
        });
    });
});
</script>

<?= $this->endSection() ?>