<?= $this->extend('website/index') ?>
<?= $this->section('content') ?>

<!-- Hero Slider Section -->
<div class="slider">
    <?php if (!empty($sliders)): ?>
        <?php foreach ($sliders as $index => $slide): 
            $slide = is_array($slide) ? (object)$slide : $slide; // Convert array to object if needed
        ?>
        <div class="slide slide-<?= $index + 1 ?> <?= $index === 0 ? 'active' : '' ?>">
            <div class="slide-image" style="background-image: url('<?= base_url('media/files/' . $slide->photo) ?>');">
                <div class="slide-content">
                    <h2><?= esc($slide->title) ?></h2>
                    <p><?= esc($slide->description) ?></p>
                    <div class="btn-container">
                        <?php if (!empty($slide->link)) : ?>
                            <a href="<?= base_url($slide->link) ?>" class="btn btn-primary">
                                <i class="<?= esc($slide->link_icon ?? 'fas fa-info-circle') ?>"></i> <?= esc($slide->link_text ?? 'Learn More') ?>
                            </a>
                        <?php endif; ?>
                        <?php if (!empty($slide->link_2)) : ?>
                            <a href="<?= base_url($slide->link_2) ?>" class="btn secondary">
                                <i class="<?= esc($slide->link_2_icon ?? 'fas fa-phone-alt') ?>"></i> <?= esc($slide->link_2_text ?? 'Contact Us') ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- Slider Navigation -->
    <div class="slider-nav">
        <div class="nav-arrow prev"><i class="fas fa-chevron-left"></i></div>
        <div class="nav-arrow next"><i class="fas fa-chevron-right"></i></div>
    </div>
    
    <!-- Slider Dots -->
    <div class="slider-dots">
        <?php if (!empty($sliders)): ?>
            <?php foreach ($sliders as $index => $slide): ?>
                <div class="dot <?= $index === 0 ? 'active' : '' ?>" data-slide="<?= $index ?>"></div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>



<!-- Banking Services Section -->
<section style="background:linear-gradient(135deg, #ffffff 0%, #f0f8ff 100%); padding:40px;">
  <div class="container">
    <div class="section-tle">Our Banking Services</div>
    <div class="section">
      <!-- Floating Buttons Wrapper -->
      <div class="floating-btns">
        <!-- Floating Buttons LEFT -->
        <a href="<?= base_url('open-account') ?>" class="floating-btn btn-left-1" data-aos="fade-up" data-aos-delay="100">
          <i class="fas fa-university"></i> Open an Account
        </a>
        <a href="<?= base_url('ways-to-bank') ?>" class="floating-btn btn-left-2" data-aos="fade-up" data-aos-delay="200">
          <i class="fas fa-credit-card"></i> Ways to Bank
        </a>
        <a href="<?= base_url('forex') ?>" class="floating-btn btn-left-3" data-aos="fade-up" data-aos-delay="300">
          <i class="fas fa-hand-holding-usd"></i> Forex Rates
        </a>
        <!-- Floating Buttons RIGHT -->
        <a href="<?= base_url('saving-accounts') ?>" class="floating-btn btn-right-1" data-aos="fade-up" data-aos-delay="100">
          <i class="fas fa-money-bill-wave"></i> Save with us
        </a>
        <a href="<?= base_url('loan-accounts') ?>" class="floating-btn btn-right-2" data-aos="fade-up" data-aos-delay="200">
          <i class="fas fa-chart-line"></i> I need a Loan
        </a>
        <a href="<?= base_url('loan-calculator') ?>" class="floating-btn btn-right-3" data-aos="fade-up" data-aos-delay="300">
          <i class="fas fa-piggy-bank"></i> Loan calculator
        </a>
      </div>
      
      <!-- Cards -->
     <?php if (!empty($service_cards)): ?>
    <?php foreach ($service_cards as $card): ?>
        <?php 
            $customFields = !empty($card['custom_fields']) ? json_decode($card['custom_fields'], true) : [];
            $iconClass = $customFields['icon_class'] ?? 'fas fa-user';

            // Get the alias/slug to use for comparison
            $card_identifier = $card['slug'] ?? $card['alias'];

            // Set the default link to the card's own page
            $card_link = base_url($card_identifier); 

            // --- Apply the Custom Redirection Logic ---
            if ($card_identifier === 'personal-banking') {
                // If it's the Personal Banking card, redirect to the top-level personal page
                $card_link = base_url('personal'); 
            } elseif ($card_identifier === 'business-banking') {
                // If it's the Business Banking card, redirect to the top-level business page
                $card_link = base_url('business'); 
            }
            // ----------------------------------------
        ?>
        <div class="card" data-aos="fade-up" data-aos-delay="400">
            <div class="card-icon">
                <i class="<?= esc($iconClass) ?>"></i>
            </div>
            <h3><?= esc($card['title']) ?></h3>
            <p><?= esc($card['excerpt']) ?></p>
            <a href="<?= esc($card_link) ?>" class="button"><?= esc($card['title']) ?></a>
        </div>
    <?php endforeach; ?>
<?php endif; ?>
    </div>
  </div>
</section>

<!-- Featured Services Section -->
<?php if (!empty($featured_services)): ?>
<section class="transfer-section">
    <div class="image-container">
        <div class="image-content">
            <h2>Global Financial Solutions</h2>
            <p>Connecting you to the world with secure and reliable services</p>
        </div>
    </div>

    <div class="content-container">
        <?php foreach ($featured_services as $index => $service): ?>
            <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                <h3><?= esc($service['title']) ?></h3>
                <p><?= esc($service['content'] ?? '') ?></p>
                <a href="<?= base_url($service['slug'] ?? $service['alias']) ?>" class="button">Learn More <i class="fas fa-arrow-right"></i></a>
            </div>
            <?php if ($index < count($featured_services) - 1): ?>
                <div class="divider"></div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</section>
<?php endif; ?>

<!-- Forex Rates Section -->
<?php if (!empty($forex_rates)): ?>
<div class="fx-section">
    <div class="container">
      <header>
        <h1><i class="fas fa-exchange-alt"></i> Foreign Exchange Rates</h1>
        <p class="last-updated">Last updated on <?= $forex_last_updated ?></p>
      </header>

      <div class="currency-cards">
        <?php foreach($forex_rates as $rate): ?>
        <div class="currency-card">
          <img src="https://flagcdn.com/w160/<?= strtolower(substr($rate->currency_code, 0, 2)) ?>.png"
               class="flag"
               alt="<?= esc($rate->currency_name) ?> Flag"
               onerror="this.src='https://via.placeholder.com/160x100?text=FLAG'">
          <div class="currency-name"><?= esc($rate->currency_name) ?></div>
          <div class="currency-code"><?= esc($rate->currency_code) ?></div>
          <div class="rates">
            <div class="rate-box buying">
              <div class="rate-label">BUYING</div>
              <div class="rate-value">UGX <?= number_format($rate->buying_rate, 2) ?></div>
            </div>
            <div class="rate-box selling">
              <div class="rate-label">SELLING</div>
              <div class="rate-value">UGX <?= number_format($rate->selling_rate, 2) ?></div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>

      <p class="disclaimer">Rates are for informational purposes only. Actual rates may vary.</p>
    </div>
</div>
<?php endif; ?>

<!-- Ways to Bank Section - Standard Banking Methods -->
<section class="ways-to-bank">
  <h2>Ways to Bank</h2>
  <div class="bank-grid">
    <div class="bank-card" data-aos="fade-up" data-aos-delay="100">
      <i class="fas fa-globe"></i>
      <h3>Internet Banking</h3>
    </div>
    <div class="bank-card" data-aos="fade-up" data-aos-delay="200">
      <i class="fas fa-mobile-alt"></i>
      <h3>Mobile Banking</h3>
    </div>
    <div class="bank-card" data-aos="fade-up" data-aos-delay="300">
      <i class="fas fa-credit-card"></i>
      <h3>ATM Banking</h3>
    </div>
    <div class="bank-card" data-aos="fade-up" data-aos-delay="100">
      <i class="fas fa-hand-holding-usd"></i>
      <h3>Agency Banking</h3>
    </div>
    <div class="bank-card" data-aos="fade-up" data-aos-delay="200">
      <i class="fas fa-phone-alt"></i>
      <h3>Phone Banking</h3>
    </div>
    <div class="bank-card" data-aos="fade-up" data-aos-delay="300">
      <i class="fas fa-university"></i>
      <h3>Branch Banking</h3>
    </div>
  </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
<script>
  AOS.init({
    duration: 1000,
    once: true
  });

  // Slider functionality
  let currentSlide = 0;
  const slides = document.querySelectorAll('.slide');

  function showSlide(index) {
    slides.forEach((slide, i) => {
      slide.classList.toggle('active', i === index);
    });
  }

  function nextSlide() {
    currentSlide = (currentSlide + 1) % slides.length;
    showSlide(currentSlide);
  }

  // Auto-advance slides every 5 seconds
  <?php if (!empty($sliders) && count($sliders) > 1): ?>
  setInterval(nextSlide, 5000);
  <?php endif; ?>



(function() {
    const slides = Array.from(document.querySelectorAll('.slide'));
    const dots = Array.from(document.querySelectorAll('.dot'));
    let currentSlide = 0;
    let slideInterval;
    
    // Add CSS for fade transition
    const style = document.createElement('style');
    style.textContent = `
        .slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
            visibility: hidden;
            will-change: opacity;
        }
        .slide.active {
            opacity: 1;
            visibility: visible;
            z-index: 1;
        }
        .slide-content {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.8s ease-in-out 0.3s, transform 0.8s ease-in-out 0.3s;
        }`;
            transition: all 0.8s ease-in-out;
        }
        .slide.active .slide-content {
            opacity: 1;
            transform: translateY(0);
        }
    `;
    document.head.appendChild(style);
    
    // Initialize slides
    slides.forEach((slide, index) => {
        slide.style.position = 'absolute';
        if (index === 0) {
            slide.classList.add('active');
        }
        // Add fade transition classes to each slide
        slide.classList.add('slider-fade');
    });
    
    function showSlide(n) {
        // Remove active class from all slides and dots
        slides.forEach(slide => {
            slide.classList.remove('active');
        });
        dots.forEach(dot => {
            dot.classList.remove('active');
        });
        
        // Calculate the correct slide index
        currentSlide = (n + slides.length) % slides.length;
        
        // Add active class to current slide and dot with a slight delay for fade effect
        setTimeout(() => {
            slides[currentSlide].classList.add('active');
            dots[currentSlide].classList.add('active');
        }, 50); // Small delay to ensure the transition is visible
    }
    
    function nextSlide() {
        showSlide(currentSlide + 1);
    }
    
    function prevSlide() {
        showSlide(currentSlide - 1);
    }
    
    function startSlider() {
        clearInterval(slideInterval);
        slideInterval = setInterval(nextSlide, 5000);
    }
    
    function resetSlider() {
        clearInterval(slideInterval);
        startSlider();
    }
    
    // Initialize
    document.querySelector('.next').addEventListener('click', function() {
        nextSlide();
        resetSlider();
    });
    
    document.querySelector('.prev').addEventListener('click', function() {
        prevSlide();
        resetSlider();
    });
    
    dots.forEach(dot => {
        dot.addEventListener('click', function() {
            let slideIndex = parseInt(this.getAttribute('data-slide'));
            showSlide(slideIndex);
            resetSlider();
        });
    });
    
    startSlider();
})();

</script>

<?= $this->endSection() ?>
