<?= $this->extend('website/index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Forex Rates Table Section -->
<section class="forex-rates-section" id="forex-table">
    <div class="container">
        <div class="forex-table-container">
            <table class="forex-rates-table">
                <thead>
                    <tr>
                        <th>Currency</th>
                        <th>Name</th>
                        <th>We Buy (UGX)</th>
                        <th>We Sell (UGX)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($forex_rates as $rate): ?>
                    <tr>
                        <td>
                            <div class="currency-code-cell">
                                <img src="<?= esc($rate->flag_icon) ?>" alt="<?= esc($rate->currency_code) ?> flag" class="currency-flag">
                                <span><?= esc($rate->currency_code) ?></span>
                                <?php if($rate->currency_symbol): ?>
                                <small class="currency-symbol">(<?= esc($rate->currency_symbol) ?>)</small>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td><?= esc($rate->currency_name) ?></td>
                        <td><?= number_format($rate->buying_rate, 2) ?></td>
                        <td><?= number_format($rate->selling_rate, 2) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div class="rate-disclaimer">
                <p><strong>Note:</strong> Rates are subject to change based on market fluctuations. Please contact us for large transactions or current rates.</p>
                <p>Last foreign exchange rates updated on <?= $forex_last_updated ?></p>
            </div>
        </div>
    </div>
</section>

<!-- Forex Calculator + FAQ Section -->
<section class="forex-tools-section">
  <div class="container tools-container">
    <!-- Currency Calculator -->
    <div class="currency-calculator-section">
      <div class="section-header">
        <h2>Currency <span>Calculator</span></h2>
        <p>Quickly calculate exchange values with our convenient tool</p>
      </div>
      <div class="calculator-contain">
        <div class="calculator-form">
          <div class="calc-row">
            <div class="calc-group">
              <label for="amount">Amount</label>
              <input type="number" id="amount" placeholder="Enter amount" min="1" step="any">
            </div>
            <div class="calc-group">
              <label for="from-currency">From</label>
              <select id="from-currency">
                <option value="UGX">UGX - Ugandan Shilling</option>
                <?php foreach($forex_rates as $rate): ?>
                <option value="<?= $rate->currency_code ?>"><?= $rate->currency_code ?> - <?= $rate->currency_name ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="calc-group">
              <label for="to-currency">To</label>
              <select id="to-currency">
                <option value="UGX" selected>UGX - Ugandan Shilling</option>
                <?php foreach($forex_rates as $rate): ?>
                <option value="<?= $rate->currency_code ?>"><?= $rate->currency_code ?> - <?= $rate->currency_name ?></option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>

          <div class="calc-result">
            <h3>Converted Amount:</h3>
            <div class="result-value" id="converted-amount">0.00</div>
          </div>

          <div class="calc-note">
            <p>This calculator provides estimates based on current rates. Actual rates may vary.</p>
          </div>
        </div>
      </div>
    </div>

    <!-- Forex FAQ -->
    <div class="forex-faq-section">
      <div class="section-header">
        <h2>Forex <span>FAQ</span></h2>
        <p>Frequently asked questions about our foreign exchange services</p>
      </div>
      <div class="faq-container">
        <div class="faq-item">
          <div class="faq-question">
            <h3>What documents do I need for foreign exchange transactions?</h3>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>For most transactions, you'll need a valid ID. For larger amounts, we may require additional documentation such as proof of source of funds or purpose of transaction.</p>
          </div>
        </div>
        <div class="faq-item">
          <div class="faq-question">
            <h3>How often are your exchange rates updated?</h3>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>Our rates are updated regularly throughout the business day to reflect market conditions. The rates shown on our website are updated at least daily.</p>
          </div>
        </div>
        <div class="faq-item">
          <div class="faq-question">
            <h3>Do you offer better rates for large transactions?</h3>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>Yes, we offer competitive rates for large transactions. Please contact our forex department directly for negotiations.</p>
          </div>
        </div>
        <div class="faq-item">
          <div class="faq-question">
            <h3>Can I reserve foreign currency in advance?</h3>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>Yes, we allow currency reservations for future needs. Contact us to discuss forward contracts.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
.currency-code-cell {
    display: flex;
    align-items: center;
    gap: 8px;
}
.currency-flag {
    width: 24px;
    height: 18px;
    object-fit: contain;
    border-radius: 2px;
    border: 1px solid #eee;
}
.currency-symbol {
    color: #666;
    font-size: 0.85em;
}
</style>

<?= $this->endSection() ?>