
<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Overview Section -->
<section class="section1 py-12 bg-gray-50">
  <div class="container mx-auto px-6">
    <div class="text-center max-w-3xl mx-auto">
      <p class="text-gray-700 text-lg leading-relaxed">
        We offer <span class="font-semibold text-blue-600">customer-centric solutions</span> that cater to the needs of the Ugandan market—especially around digital-based payments, customer acquisition, merchants, savings, electronic loans, and insurance.
      </p>
      <p class="mt-4 text-gray-800 font-medium text-xl">
        See the commonly asked questions below:
      </p>
    </div>
  </div>
</section>


<!-- FAQ Section -->
<section class="faq-section">
    <div class="container">
        <div class="section-title">
            <h2>Frequently Asked Questions</h2>
        </div>
        <div class="faq-container">
            <?php if (!empty($faqs)): ?>
                <?php foreach ($faqs as $faq): ?>
                    <div class="faq-item">
                        <div class="faq-question">
                            <h3><?= esc($faq->subject_name); ?></h3>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="faq-answer">
                            <p><?= esc($faq->answer); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No FAQs available at the moment.</p>
            <?php endif; ?>
        </div>
    </div>
</section>

<script>
    const faqItems = document.querySelectorAll('.faq-item');

    faqItems.forEach(item => {
        const question = item.querySelector('.faq-question');
        question.addEventListener('click', () => {
            const answer = item.querySelector('.faq-answer');
            const icon = question.querySelector('i');

            if (item.classList.contains('active')) {
                item.classList.remove('active');
                answer.style.maxHeight = 0;
                icon.style.transform = 'rotate(0deg)';
            } else {
                // Close all other open FAQs
                faqItems.forEach(otherItem => {
                    if (otherItem.classList.contains('active')) {
                        otherItem.classList.remove('active');
                        otherItem.querySelector('.faq-answer').style.maxHeight = 0;
                        otherItem.querySelector('.faq-question i').style.transform = 'rotate(0deg)';
                    }
                });

                item.classList.add('active');
                answer.style.maxHeight = answer.scrollHeight + 'px';
                icon.style.transform = 'rotate(180deg)';
            }
        });
    });
</script>

<?= $this->endSection() ?>
