<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<style>
/* ===== VARIABLES ===== */
:root {
    --primary-color: #0d6efd;
    --primary-dark: #0b5ed7;
    --secondary-color: #6c757d;
    --success-color: #198754;
    --danger-color: #dc3545;
    --light-color: #f8f9fa;
    --dark-color: #212529;
    --border-radius: 0.375rem;
    --box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --transition: all 0.3s ease;
}

/* ===== DOWNLOADS SECTION ===== */
.downloads-section {
    padding: 2rem 0;
}

.downloads-card {
    box-shadow: var(--box-shadow);
    border: none;
    border-radius: var(--border-radius);
    background-color: #fff;
    transition: var(--transition);
    overflow: hidden;
}

.downloads-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.downloads-card-body {
    padding: 1.5rem;
}

.downloads-card-header {
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.downloads-card-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-color);
    margin: 0;
}

.downloads-table {
    width: 100%;
    margin-bottom: 0;
    border-collapse: collapse;
}

.downloads-table thead {
    background-color: var(--light-color);
}

.downloads-table th {
    text-transform: uppercase;
    color: var(--secondary-color);
    font-weight: 600;
    font-size: 0.85rem;
    padding: 0.75rem;
    border-bottom: 1px solid #dee2e6;
}

.downloads-table td {
    padding: 0.75rem;
    vertical-align: middle;
    border-bottom: 1px solid #dee2e6;
    transition: var(--transition);
}

.downloads-table tbody tr:hover td {
    background-color: rgba(13, 110, 253, 0.05);
}

.downloads-table .file-icon {
    font-size: 1.25rem;
    margin-right: 0.5rem;
    color: var(--primary-color);
}

.downloads-table .file-title {
    font-weight: 600;
    color: var(--dark-color);
}

.downloads-table .file-date {
    color: var(--secondary-color);
    font-size: 0.875rem;
}

.downloads-btn {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #fff;
    background-color: var(--primary-color);
    border: 1px solid var(--primary-color);
    border-radius: 50rem;
    text-decoration: none;
    transition: var(--transition);
}

.downloads-btn:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    color: #fff;
    transform: translateY(-2px);
}

/* ===== CALCULATOR SECTION ===== */
.calculator-card {
    box-shadow: var(--box-shadow);
    border: none;
    border-radius: var(--border-radius);
    background-color: #fff;
    transition: var(--transition);
    overflow: hidden;
}

.calculator-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.calculator-card-body {
    padding: 1.5rem;
}

.calculator-card-header {
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.calculator-card-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-color);
    margin: 0;
}

.form-group {
    margin-bottom: 1.25rem;
    position: relative;
}

.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: var(--dark-color);
}

.form-control {
    width: 100%;
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    border: 1px solid #ced4da;
    border-radius: var(--border-radius);
    transition: var(--transition);
}

.form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}

.form-control:disabled {
    background-color: #e9ecef;
    opacity: 1;
}

.btn-calculate {
    width: 100%;
    padding: 0.75rem;
    font-size: 1rem;
    font-weight: 600;
    color: #fff;
    background-color: var(--primary-color);
    border: 1px solid var(--primary-color);
    border-radius: var(--border-radius);
    transition: var(--transition);
    cursor: pointer;
}

.btn-calculate:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    transform: translateY(-2px);
}

.btn-calculate:active {
    transform: translateY(0);
}

/* ===== LOADING SPINNER ===== */
.loading-spinner {
    display: inline-block;
    width: 2rem;
    height: 2rem;
    border: 0.25em solid #f3f3f3;
    border-top: 0.25em solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* ===== RESULTS SECTION ===== */
.results-section {
    margin-top: 1.5rem;
    padding-top: 1.5rem;
    border-top: 1px solid #e9ecef;
}

.results-group {
    margin-bottom: 1rem;
}

.results-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: var(--dark-color);
}

.input-group {
    display: flex;
    border-radius: var(--border-radius);
    overflow: hidden;
}

.input-group input {
    flex: 1;
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
    border-right: none;
}

.input-group span {
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #e9ecef;
    border: 1px solid #ced4da;
    min-width: 60px;
    text-align: center;
}

/* ===== ERROR MESSAGES ===== */
.alert {
    padding: 0.75rem 1rem;
    margin-bottom: 1rem;
    border: 1px solid transparent;
    border-radius: var(--border-radius);
}

.alert-danger {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

/* ===== RESPONSIVE ADJUSTMENTS ===== */
@media (max-width: 991.98px) {
    .calculator-card {
        margin-top: 2rem;
    }
}

@media (max-width: 575.98px) {
    .downloads-card-body,
    .calculator-card-body {
        padding: 1rem;
    }
    
    .input-group {
        flex-direction: column;
    }
    
    .input-group input {
        border-right: 1px solid #ced4da;
        border-bottom: none;
    }
    
    .input-group span {
        border-top: none;
    }
}
</style>

<!-- Page Content -->
<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>
</section>

<!-- Content Area -->
<section class="downloads-section py-5">
    <div class="container">
        <div class="row">
            <!-- Downloads Section -->
            <div class="col-lg-8">
                <div class="downloads-card">
                    <div class="downloads-card-body">
                        <div class="downloads-card-header">
                            <h2 class="downloads-card-title">Download Your Reports</h2>
                        </div>

                        <?php if (!empty($downloads)): ?>
                            <!-- Category Tabs -->
                            <ul class="nav nav-tabs mb-3" id="downloadTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="all-tab" type="button">All</button>
                                </li>
                                <?php foreach ($categories as $category): ?>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="cat-<?= $category->id ?>-tab" type="button">
                                            <?= esc($category->name) ?>
                                        </button>
                                    </li>
                                <?php endforeach; ?>
                            </ul>

                            <div class="table-responsive">
                                <table id="postslist" class="downloads-table">
                                    <thead>
                                        <tr>
                                            <th scope="col">Title</th>
                                            <th scope="col">Date Created</th>
                                            <th scope="col">Download</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($downloads as $download): ?>
                                            <tr data-category="<?= $download->category_id ?>">
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <?php
                                                        $fileExtension = pathinfo($download->file ?? '', PATHINFO_EXTENSION);
                                                        $iconClass = 'bi-file-earmark';
                                                        switch (strtolower($fileExtension)) {
                                                            case 'pdf':
                                                                $iconClass = 'bi-file-earmark-pdf';
                                                                break;
                                                            case 'doc':
                                                            case 'docx':
                                                                $iconClass = 'bi-file-earmark-word';
                                                                break;
                                                            case 'xls':
                                                            case 'xlsx':
                                                                $iconClass = 'bi-file-earmark-excel';
                                                                break;
                                                            case 'ppt':
                                                            case 'pptx':
                                                                $iconClass = 'bi-file-earmark-ppt';
                                                                break;
                                                            case 'zip':
                                                            case 'rar':
                                                                $iconClass = 'bi-file-earmark-zip';
                                                                break;
                                                            default:
                                                                $iconClass = 'bi-file-earmark';
                                                                break;
                                                        }
                                                        ?>
                                                        <i class="bi <?= $iconClass ?>-fill file-icon"></i>
                                                        <div class="d-inline-block align-middle">
                                                            <div class="file-title"><?= esc($download->title) ?></div>
                                                            <small class="file-date"><?= esc(date('d M Y', strtotime($download->created_at))) ?></small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><small class="file-date fw-medium"><?= esc(date('d M Y', strtotime($download->created_at))) ?></small></td>
                                                <td>
                                                    <?php if (!empty($download->file)): ?>
                                                        <a href="<?= base_url('media/downloads/files/' . $download->file) ?>" class="downloads-btn" target="_blank" title="Download <?= strtoupper($fileExtension) ?>">
                                                            <i class="bi bi-download me-1"></i>Download
                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No downloads available at the moment.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Calculator Section -->
            <div class="col-lg-4">
                <div class="calculator-card">
                    <div class="calculator-card-body">
                        <div class="calculator-card-header">
                            <h2 class="calculator-card-title">Calculate Your Loan</h2>
                        </div>

                        <!-- Loan Calculator -->
                        <form id="loan-form">
                            <div class="form-group">
                                <label for="amount" class="form-label">Total Amount (UGX)</label>
                                <input type="number" id="amount" class="form-control" placeholder="Enter amount" step="0.01" min="0" required>
                                <small class="form-text text-muted">Enter the loan amount in UGX</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="interest" class="form-label">Interest Rate (%)</label>
                                <input type="number" id="interest" class="form-control" placeholder="Enter interest rate" step="0.01" min="0" required>
                                <small class="form-text text-muted">Annual interest rate percentage</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="years" class="form-label">Loan Term (Years)</label>
                                <input type="number" id="years" class="form-control" placeholder="Enter years" step="0.5" min="0.5" max="30" required>
                                <small class="form-text text-muted">Loan duration in years (0.5 to 30)</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="payment-period" class="form-label">Payment Frequency</label>
                                <select id="payment-period" class="form-control" required>
                                    <option value="12">Monthly</option>
                                    <option value="4">Quarterly</option>
                                    <option value="2">Semi-annually</option>
                                    <option value="1">Annually</option>
                                </select>
                                <small class="form-text text-muted">How often payments will be made</small>
                            </div>

                            <button type="submit" class="btn-calculate" id="calculate-btn">
                                Calculate Loan Payments
                            </button>
                            
                            <!-- Honeypot field for spam protection -->
                            <div style="display:none">
                                <label>Fill This Field</label>
                                <input type="text" name="honeypot" value="">
                            </div>
                        </form>

                        <!-- Loading Spinner -->
                        <div id="loading" class="text-center mt-3" style="display: none;">
                            <div class="loading-spinner" role="status">
                                <span class="visually-hidden">Calculating...</span>
                            </div>
                            <p class="mt-2">Calculating your loan...</p>
                        </div>

                        <!-- Results Section -->
                        <div id="results" class="results-section" style="display: none;">
                            <h3 class="h5 mb-3">Loan Calculation Results</h3>
                            
                            <div class="results-group">
                                <label for="monthly-payment">Payment Amount:</label>
                                <div class="input-group">
                                    <input type="text" id="monthly-payment" class="form-control" aria-label="Payment Amount" readonly>
                                    <span>UGX</span>
                                </div>
                            </div>
                            
                            <div class="results-group">
                                <label for="total-payment">Total Payment:</label>
                                <div class="input-group">
                                    <input type="text" id="total-payment" class="form-control" aria-label="Total Payment" readonly>
                                    <span>UGX</span>
                                </div>
                            </div>
                            
                            <div class="results-group">
                                <label for="total-interest">Total Interest:</label>
                                <div class="input-group">
                                    <input type="text" id="total-interest" class="form-control" aria-label="Total Interest" readonly>
                                    <span>UGX</span>
                                </div>
                            </div>
                            
                            <div class="results-group">
                                <label for="total-payments">Number of Payments:</label>
                                <div class="input-group">
                                    <input type="text" id="total-payments" class="form-control" aria-label="Number of Payments" readonly>
                                    <span></span>
                                </div>
                            </div>
                        </div>
                        <!-- END loan calculator -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize variables
    const loanForm = document.getElementById('loan-form');
    const resultsSection = document.getElementById('results');
    const loadingSection = document.getElementById('loading');
    const calculateBtn = document.getElementById('calculate-btn');
    
    // Initially hide results
    resultsSection.style.display = 'none';
    
    // Add form submission handler
    loanForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Hide results and show loading
        resultsSection.style.display = 'none';
        loadingSection.style.display = 'block';
        calculateBtn.disabled = true;
        
        // Simulate calculation delay for better UX
        setTimeout(calculateLoan, 800);
    });
    
    function calculateLoan() {
        // Get form values
        const amount = parseFloat(document.getElementById('amount').value);
        const interestRate = parseFloat(document.getElementById('interest').value);
        const years = parseFloat(document.getElementById('years').value);
        const paymentPeriod = parseInt(document.getElementById('payment-period').value);
        
        // Validate inputs
        if (isNaN(amount) || isNaN(interestRate) || isNaN(years) || isNaN(paymentPeriod)) {
            showError('Please fill in all fields with valid numbers');
            return;
        }
        
        if (amount <= 0 || interestRate < 0 || years <= 0) {
            showError('Please enter positive values for amount, interest rate, and years');
            return;
        }
        
        // Calculate loan details
        const periodicInterestRate = (interestRate / 100) / paymentPeriod;
        const totalPayments = years * paymentPeriod;
        
        // Calculate payment amount
        let paymentAmount;
        if (periodicInterestRate === 0) {
            // Simple division for zero interest
            paymentAmount = amount / totalPayments;
        } else {
            // Standard loan payment formula
            const x = Math.pow(1 + periodicInterestRate, totalPayments);
            paymentAmount = (amount * x * periodicInterestRate) / (x - 1);
        }
        
        // Calculate totals
        const totalPayment = paymentAmount * totalPayments;
        const totalInterest = totalPayment - amount;
        
        // Check for valid calculation
        if (isFinite(paymentAmount)) {
            // Format and display results
            document.getElementById('monthly-payment').value = formatCurrency(paymentAmount);
            document.getElementById('total-payment').value = formatCurrency(totalPayment);
            document.getElementById('total-interest').value = formatCurrency(totalInterest);
            document.getElementById('total-payments').value = totalPayments;
            
            // Show results and hide loading
            resultsSection.style.display = 'block';
            loadingSection.style.display = 'none';
            calculateBtn.disabled = false;
            
            // Scroll to results for better UX
            resultsSection.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        } else {
            showError('Invalid calculation. Please check your inputs.');
        }
    }
    
    function formatCurrency(amount) {
        // Format as currency with commas for thousands
        return amount.toLocaleString('en-US', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
    
    function showError(message) {
        // Hide loading and enable button
        loadingSection.style.display = 'none';
        calculateBtn.disabled = false;
        
        // Remove any existing error messages
        const existingError = document.querySelector('.alert-danger');
        if (existingError) {
            existingError.remove();
        }
        
        // Create and display error message
        const errorDiv = document.createElement('div');
        errorDiv.className = 'alert alert-danger';
        errorDiv.innerHTML = `<strong>Error:</strong> ${message}`;
        
        // Insert error message before the form
        loanForm.parentNode.insertBefore(errorDiv, loanForm);
        
        // Auto-remove error after 5 seconds
        setTimeout(() => {
            if (errorDiv.parentNode) {
                errorDiv.remove();
            }
        }, 5000);
    }
});

// Initialize DataTable for downloads
$(document).ready(function () {
    var currentCategoryFilter = 'all';

    var table = $('#postslist').DataTable({
        pageLength: 10,
        order: [[0, "desc"]],
        language: {
            search: "Search downloads:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        }
    });

    // Custom search function for category filtering
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
        if (currentCategoryFilter === 'all') {
            return true;
        }
        var category = $(settings.aoData[dataIndex].nTr).data('category');
        return category == currentCategoryFilter;
    });

    // Tab filtering functionality
    $('#downloadTabs .nav-link').on('click', function (e) {
        e.preventDefault();

        // Remove active class from all tabs
        $('#downloadTabs .nav-link').removeClass('active');
        // Add active class to clicked tab
        $(this).addClass('active');

        const tabId = $(this).attr('id');
        currentCategoryFilter = tabId === 'all-tab' ? 'all' : tabId.replace('cat-', '').replace('-tab', '');

        // Redraw table to apply filter
        table.draw();
    });
});
</script>

<?= $this->endSection() ?>