<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Overview Section -->
<section class="overview-section-image">
    <div class="container">
        <div class="side-image-layout">
            <div class="content-side">
                <h2><?= renderEmphasized(
                    $templateData['overview_title'] ?? 'Elevate Your Banking Experience',
                    $templateData['overview_title_emphasized'] ?? null
                ) ?></h2>
                <p><?= $templateData['overview_content'] ?? $page['content'] ?></p>

                <?php if(isset($templateData['feature_highlights'])): ?>
                    <div class="feature-highlights">
                        <?php foreach($templateData['feature_highlights'] as $feature): ?>
                            <div class="feature-item">
                                <i class="<?= $feature['icon'] ?? 'fas fa-star' ?>"></i>
                                <span><?= $feature['title'] ?? $feature['text'] ?? '' ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <div class="image-side">
                <img src="<?= isset($templateData['overview_image']) && !empty($templateData['overview_image']) ? base_url('media/files/' . $templateData['overview_image']) : base_url('media/files/mobile.jpg') ?>" alt="<?= esc($page['title']) ?>">
            </div>
        </div>
    </div>
</section>

<!-- Eligibility Section -->
<?php if(isset($templateData['eligibility'])): ?>
<section class="relaxer-section">
    <div class="relaxer-overlay">
        <div class="relaxer-content">
            <h2><?= $templateData['eligibility']['title'] ?? 'Eligibility Requirements' ?></h2>
            <p><?= $templateData['eligibility']['description'] ?? 'To qualify for this account, applicants must meet the following requirements:' ?></p>

            <ul class="eligibility-list">
                <?php foreach($templateData['eligibility']['items'] as $item): ?>
                    <li><?= $item['title'] ?? $item ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Forex Rates Section (from separate table) -->
<?php if (!empty($forex_rates)): ?>
<div class="fx-section">
    <div class="container">
      <header>
        <h1><i class="fas fa-exchange-alt"></i> Foreign Exchange Rates</h1>
        <p class="last-updated">Last updated on <?= $forex_last_updated ?></p>
      </header>

      <div class="currency-cards">
        <?php foreach($forex_rates as $rate): ?>
        <div class="currency-card">
          <img src="https://flagcdn.com/w160/<?= strtolower(substr($rate->currency_code, 0, 2)) ?>.png"
               class="flag"
               alt="<?= esc($rate->currency_name) ?> Flag"
               onerror="this.src='https://via.placeholder.com/160x100?text=FLAG'">
          <div class="currency-name"><?= esc($rate->currency_name) ?></div>
          <div class="currency-code"><?= esc($rate->currency_code) ?></div>
          <div class="rates">
            <div class="rate-box buying">
              <div class="rate-label">BUYING</div>
              <div class="rate-value">UGX <?= number_format($rate->buying_rate, 2) ?></div>
            </div>
            <div class="rate-box selling">
              <div class="rate-label">SELLING</div>
              <div class="rate-value">UGX <?= number_format($rate->selling_rate, 2) ?></div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>

      <p class="disclaimer">Rates are for informational purposes only. Actual rates may vary.</p>
    </div>
</div>
<?php endif; ?>

<!-- Benefits Section -->
<?php if(isset($templateData['benefits'])): ?>
<section class="benefits-section">
    <div class="container">
        <div class="section-header">
            <h2><?= renderEmphasized(
                $templateData['benefits']['title'] ?? 'Benefits',
                $templateData['benefits']['title_emphasized'] ?? null
            ) ?></h2>
            <p><?= $templateData['benefits']['subtitle'] ?? 'Why choose this account' ?></p>
        </div>

        <div class="benefits-grid">
            <?php foreach($templateData['benefits']['items'] as $benefit): ?>
                <div class="benefit-card">
                    <div class="benefit-icon">
                        <i class="<?= $benefit['icon'] ?? 'fas fa-star' ?>"></i>
                    </div>
                    <h3><?= $benefit['title'] ?? '' ?></h3>
                    <p><?= $benefit['description'] ?? '' ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection(); ?>