<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CSR Content -->
<section class="governance-content">
    <div class="container">

        <!-- Commitment Section -->
        <?php if(!empty($templateData['commitment'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['commitment']['title'] ?? 'Our Commitment',
            $templateData['commitment']['title_emphasized'] ?? 'Commitment'
        ) ?></h2>
        <div class="governance-intro">
            <?php if(!empty($templateData['commitment']['content'])): ?>
                <?php 
                // Convert line breaks to paragraphs to match original structure
                $paragraphs = preg_split('/\r\n|\r|\n/', $templateData['commitment']['content']);
                foreach ($paragraphs as $paragraph) {
                    if (trim($paragraph) !== '') {
                        echo '<p>' . esc($paragraph) . '</p>';
                    }
                }
                ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Focus Areas -->
        <?php if(!empty($templateData['focus_areas'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['focus_areas']['title'] ?? 'Focus Areas',
            $templateData['focus_areas']['title_emphasized'] ?? 'Areas'
        ) ?></h2>
        
        <?php 
        $focusItems = $templateData['focus_areas']['items'] ?? [];
        ?>
        
        <!-- First Row - Exactly like original -->
        <div class="responsibilities-section">
            <?php if(isset($focusItems[0])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($focusItems[0]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($focusItems[0]['title']) ?></h3>
                <p><?= esc($focusItems[0]['description']) ?></p>
            </div>
            <?php endif; ?>
            
            <?php if(isset($focusItems[1])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($focusItems[1]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($focusItems[1]['title']) ?></h3>
                <p><?= esc($focusItems[1]['description']) ?></p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Second Row - Exactly like original -->
        <div class="responsibilities-section">
            <?php if(isset($focusItems[2])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($focusItems[2]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($focusItems[2]['title']) ?></h3>
                <p><?= esc($focusItems[2]['description']) ?></p>
            </div>
            <?php endif; ?>
            
            <?php if(isset($focusItems[3])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($focusItems[3]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($focusItems[3]['title']) ?></h3>
                <p><?= esc($focusItems[3]['description']) ?></p>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- CSR Highlights -->
        <?php if(!empty($templateData['highlights'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['highlights']['title'] ?? 'CSR Highlights',
            $templateData['highlights']['title_emphasized'] ?? 'Highlights'
        ) ?></h2>
        <div class="board-highlights">
            <?php if(!empty($templateData['highlights']['items'])): ?>
                <?php foreach($templateData['highlights']['items'] as $highlight): ?>
                <div class="highlight-item">
                    <div class="highlight-icon"><i class="<?= esc($highlight['icon'] ?? 'fas fa-star') ?>"></i></div>
                    <h4><?= esc($highlight['title']) ?></h4>
                    <p><?= esc($highlight['description']) ?></p>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection(); ?>