<?= $this->extend('App\Views\website\index') ?>

<?= $this->section('pageStyles') ?>
<!-- Add SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-bootstrap-4/bootstrap-4.min.css">
<link rel="stylesheet" href="<?= base_url('assets/front_assets/css/form-validation.css') ?>">
<style>
.guidance-text {
    font-size: 0.8rem;
    margin-top: 0.25rem;
    color: #6c757d !important;
}

.guidance-text i {
    margin-right: 0.25rem;
}

.field-error {
    font-size: 0.875em;
    margin-top: 0.25rem;
}

.char-count {
    text-align: right;
    font-size: 0.8rem;
    margin-top: 0.25rem;
    color: #6c757d;
}

.form-control.is-invalid {
    border-color: #dc3545;
    padding-right: calc(1.5em + 0.75rem);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath d='m5.8 3.6.4.4.4-.4'/%3e%3cpath d='M6 7v1'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
}

.btn-loading {
    display: none;
}

.swal2-show-validation-errors .swal2-html-container {
    text-align: left;
}
</style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Contact Methods Section -->
<?php if (!empty($templateData['contact_methods']['items'])): ?>
<section class="contact-methods-section">
    <div class="container" style="margin-top:-100px;">
        <div class="contact-methods-grid">
            <?php foreach ($templateData['contact_methods']['items'] as $method): ?>
                <div class="contact-method">
                    <div class="contact-icon">
                        <i class="<?= esc($method['icon']) ?>"></i>
                    </div>
                    <h3><?= esc($method['title']) ?></h3>
                    <?php foreach ($method['details'] as $detail): ?>
                        <p><?= esc(trim($detail)) ?></p>
                    <?php endforeach; ?>
                    <?php if (!empty($method['note'])): ?>
                        <p class="contact-note"><?= esc($method['note']) ?></p>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Contact Form Section -->
<section class="contact-form-section" id="contact-form">
    <div class="container">
        <div class="section-header">
            <h2><?= esc($templateData['contact_form']['title']) ?> <span>Message</span></h2>
            <p><?= esc($templateData['contact_form']['subtitle']) ?></p>
        </div>
        
        <!-- Success/Error Messages -->
        <div id="form-messages" style="display: none;"></div>
        
        <div class="form-container">
            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger">
                    <?= session()->get('error') ?>
                </div>
            <?php endif; ?>
            
            <?php if(session()->has('success')): ?>
                <div class="alert alert-success">
                    <?= session()->get('success') ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?= base_url('contact-us/submit') ?>" class="contact-form" id="bank-contact-form" novalidate>
                <?= csrf_field() ?>
                
                <!-- Name Field -->
                <div class="form-group full-width">
                    <label for="name">
                        Full Name <span class="text-danger">*</span>
                    </label>
                    <input type="text" id="name" name="name" required value="<?= old('name') ?>"
                          
                           class="form-control <?= (validation_show_error('name')) ? 'is-invalid' : '' ?>"
                           data-rules="Must be at least 2 characters, letters and spaces only">
                   
                    <?php if (validation_show_error('name')): ?>
                        <div class="invalid-feedback">
                            <?= validation_show_error('name') ?>
                        </div>
                    <?php endif; ?>
                    <div class="field-error" id="name-error" style="display: none;"></div>
                </div>

                <!-- Phone and Email Row -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="phone">
                            Phone Number <span class="text-danger">*</span>
                        </label>
                        <input type="tel" id="phone" name="phone" required value="<?= old('phone') ?>"
                               placeholder="+256 XXX XXX XXX"
                               class="form-control <?= (validation_show_error('phone')) ? 'is-invalid' : '' ?>"
                               data-rules="Include country code, numbers only, 10-20 digits">
                        <small class="form-text text-muted guidance-text">
                            <i class="fas fa-info-circle"></i> Include country code (e.g., +256), numbers only, 10-20 digits
                        </small>
                        <?php if (validation_show_error('phone')): ?>
                            <div class="invalid-feedback">
                                <?= validation_show_error('phone') ?>
                            </div>
                        <?php endif; ?>
                        <div class="field-error" id="phone-error" style="display: none;"></div>
                    </div>
                    
                    <div class="form-group">
                        <label for="email">
                            Email Address <span class="text-danger">*</span>
                        </label>
                        <input type="email" id="email" name="email" required value="<?= old('email') ?>"
                               placeholder="your.email@example.com"
                               class="form-control <?= (validation_show_error('email')) ? 'is-invalid' : '' ?>"
                               data-rules="Valid email format required">
                      
                        <?php if (validation_show_error('email')): ?>
                            <div class="invalid-feedback">
                                <?= validation_show_error('email') ?>
                            </div>
                        <?php endif; ?>
                        <div class="field-error" id="email-error" style="display: none;"></div>
                    </div>
                </div>

                <!-- Subject Dropdown -->
                <div class="form-group full-width">
                    <label for="subject_id">
                        How can we Help You? <span class="text-danger">*</span>
                    </label>
                    <select id="subject_id" name="subject_id" required
                            class="form-control <?= (validation_show_error('subject_id')) ? 'is-invalid' : '' ?>"
                            data-rules="Please select a subject from the list">
                        <option value="">Choose Subject</option>
                        <?php foreach ($subjects as $subject): ?>
                            <option value="<?= esc($subject->id) ?>" <?= old('subject_id') == $subject->id ? 'selected' : '' ?>>
                                <?= esc($subject->title) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <?php if (validation_show_error('subject_id')): ?>
                        <div class="invalid-feedback">
                            <?= validation_show_error('subject_id') ?>
                        </div>
                    <?php endif; ?>
                    <div class="field-error" id="subject_id-error" style="display: none;"></div>
                </div>

                <!-- Account Type Dropdown -->
                <div class="form-group full-width">
                    <label for="account_type">
                        What type of banking do you need help with?
                    </label>
                    <select id="account_type" name="account_type"
                            class="form-control <?= (validation_show_error('account_type')) ? 'is-invalid' : '' ?>"
                            data-rules="Optional - select relevant banking service">
                        <option value="">Please Select</option>
                        <?php foreach ($accountTypes as $accountType): ?>
                            <option value="<?= esc($accountType->id) ?>" <?= old('account_type') == $accountType->id ? 'selected' : '' ?>>
                                <?= esc($accountType->title) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <?php if (validation_show_error('account_type')): ?>
                        <div class="invalid-feedback">
                            <?= validation_show_error('account_type') ?>
                        </div>
                    <?php endif; ?>
                    <div class="field-error" id="account_type-error" style="display: none;"></div>
                </div>

                <!-- Message Field -->
                <div class="form-group full-width">
                    <label for="message">
                        Your Message <span class="text-danger">*</span>
                    </label>
                    <textarea id="message" name="message" rows="5" required
                            placeholder="Please describe your inquiry in detail. Include any specific questions or concerns you'd like us to address."
                            class="form-control <?= (validation_show_error('message')) ? 'is-invalid' : '' ?>"
                            data-rules="Minimum 10 characters, maximum 2000 characters"><?= old('message') ?></textarea>
                    <small class="form-text text-muted guidance-text">
                        <i class="fas fa-info-circle"></i> (minimum 10 characters)
                    </small>
                    <div class="char-count">
                        <span id="message-char-count">0</span> / 2000 characters
                    </div>
                    <?php if (validation_show_error('message')): ?>
                        <div class="invalid-feedback">
                            <?= validation_show_error('message') ?>
                        </div>
                    <?php endif; ?>
                    <div class="field-error" id="message-error" style="display: none;"></div>
                </div>
<span class="text-danger"><small><strong>NOTE:</strong> Fields marked <strong>*</strong> are mandatory</small></span>
                <!-- Honeypot Field (Hidden) -->
                <div style="display:none">
                    <label>Fill This Field</label>
                    <input type="text" name="honeypot" value="">
                </div>

                <!-- Submit Button -->
                <div class="form-submit">
                    <button type="submit" id="send_form" class="btn btn-primary">
                        <span class="btn-text">Submit your Feedback</span>
                        <span class="btn-loading" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i> Processing...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</section>

<!-- Branches Section -->
<?php if (!empty($templateData['branches']['items'])): ?>
<section class="branches-section" id="branches">
    <div class="container">
        <div class="section-header">
            <h2><?= esc($templateData['branches']['title']) ?> <span>Branches</span></h2>
            <?php if (!empty($templateData['branches']['subtitle'])): ?>
                <p><?= esc($templateData['branches']['subtitle']) ?></p>
            <?php endif; ?>
        </div>
        
        <div class="branches-container">
            <?php foreach ($templateData['branches']['items'] as $branch): ?>
                <div class="branch-card">
                    <div class="branch-header">
                        <h3><?= esc($branch['title']) ?></h3>
                        <div class="branch-icon">
                            <i class="<?= esc($branch['icon']) ?>"></i>
                        </div>
                    </div>
                    <div class="branch-details">
                        <?php 
                        // Parse the details to add appropriate icons based on content
                        foreach ($branch['details'] as $detail): 
                            $detail = trim($detail);
                            $icon = 'fas fa-circle'; // default icon
                            
                            // Determine icon based on content
                            if (stripos($detail, 'Plot') !== false || stripos($detail, 'Road') !== false || stripos($detail, 'Street') !== false) {
                                $icon = 'fas fa-map-marker-alt';
                            } elseif (stripos($detail, 'Tel:') !== false || stripos($detail, 'Phone') !== false || stripos($detail, 'Customer Care') !== false) {
                                $icon = 'fas fa-phone';
                            } elseif (stripos($detail, 'Email:') !== false) {
                                $icon = 'fas fa-envelope';
                            } elseif (stripos($detail, 'Web:') !== false || stripos($detail, 'www.') !== false) {
                                $icon = 'fas fa-globe';
                            } elseif (stripos($detail, 'Branch Manager') !== false) {
                                $icon = 'fas fa-user-tie';
                            } elseif (stripos($detail, 'Ops Manager') !== false) {
                                $icon = 'fas fa-cogs';
                            } elseif (stripos($detail, 'P.O.Box') !== false) {
                                $icon = 'fas fa-envelope';
                            }
                        ?>
                            <p><i class="<?= $icon ?>"></i> <?= esc($detail) ?></p>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>
<!-- Add SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const form = document.getElementById("bank-contact-form");
    const messageTextarea = document.getElementById("message");
    const charCount = document.getElementById("message-char-count");

    if (form) {
        // Initialize character counter
        if (messageTextarea && charCount) {
            messageTextarea.addEventListener('input', function() {
                charCount.textContent = this.value.length;
                if (this.value.length > 2000) {
                    charCount.style.color = '#dc3545';
                } else if (this.value.length > 1900) {
                    charCount.style.color = '#ffc107';
                } else {
                    charCount.style.color = '#28a745';
                }
            });
            
            // Initialize count on page load
            charCount.textContent = messageTextarea.value.length;
        }

        // Field validators
        const validators = {
            name: (value) => {
                if (!value.trim()) return "Full Name is required";
                if (value.length < 2) return "Full Name must be at least 2 characters long";
                if (!/^[a-zA-Z\s]+$/.test(value)) return "Full Name can only contain letters and spaces";
                return "";
            },
            email: (value) => {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!value.trim()) return "Email Address is required";
                if (!emailRegex.test(value)) return "Please enter a valid email address";
                return "";
            },
            phone: (value) => {
                if (!value.trim()) return "Phone Number is required";
                if (value.length < 10) return "Phone Number must be at least 10 digits";
                if (!/^\+?[0-9\s\-\(\)]+$/.test(value)) return "Phone Number can only contain numbers, spaces, and valid phone characters";
                return "";
            },
            subject_id: (value) => {
                if (!value || value === "") return "Please select a Subject";
                return "";
            },
            message: (value) => {
                if (!value.trim()) return "Message is required";
                if (value.length < 10) return "Message must be at least 10 characters long";
                if (value.length > 2000) return "Message cannot exceed 2000 characters";
                return "";
            }
        };

        // Real-time validation
        function setupRealTimeValidation() {
            const fields = ['name', 'email', 'phone', 'subject_id', 'message'];
            
            fields.forEach(fieldName => {
                const field = form.querySelector(`[name="${fieldName}"]`);
                if (field) {
                    // Validate on blur
                    field.addEventListener('blur', function() {
                        validateField(fieldName, this.value);
                    });
                    
                    // Clear error on input
                    field.addEventListener('input', function() {
                        clearFieldError(fieldName);
                        // For message field, update character count
                        if (fieldName === 'message' && charCount) {
                            charCount.textContent = this.value.length;
                        }
                    });
                }
            });
        }

        // Validate single field
        function validateField(fieldName, value) {
            const error = validators[fieldName](value);
            if (error) {
                showFieldError(fieldName, error);
                return false;
            } else {
                clearFieldError(fieldName);
                return true;
            }
        }

        // Show field error
        function showFieldError(fieldName, message) {
            const field = form.querySelector(`[name="${fieldName}"]`);
            const errorElement = document.getElementById(`${fieldName}-error`);
            
            if (field) {
                field.classList.add('is-invalid');
                field.style.borderColor = '#dc3545';
            }
            
            if (errorElement) {
                errorElement.textContent = message;
                errorElement.style.display = 'block';
                errorElement.style.color = '#dc3545';
                errorElement.style.fontSize = '0.875em';
                errorElement.style.marginTop = '0.25rem';
            }
        }

        // Clear field error
        function clearFieldError(fieldName) {
            const field = form.querySelector(`[name="${fieldName}"]`);
            const errorElement = document.getElementById(`${fieldName}-error`);
            
            if (field) {
                field.classList.remove('is-invalid');
                field.style.borderColor = '';
            }
            
            if (errorElement) {
                errorElement.style.display = 'none';
            }
        }

        // Reset all validation states
        function resetValidationState() {
            const fields = ['name', 'email', 'phone', 'subject_id', 'account_type', 'message'];
            fields.forEach(fieldName => clearFieldError(fieldName));
            
            const formMessages = document.getElementById("form-messages");
            if (formMessages) {
                formMessages.style.display = "none";
                formMessages.className = "";
                formMessages.textContent = "";
            }

            // Clear any previous SweetAlert dialogs
            if (typeof Swal !== "undefined") {
                Swal.close();
            }
        }

        // Validate entire form
        function validateForm() {
            const errors = [];
            let isValid = true;

            // Validate each field
            Object.keys(validators).forEach(fieldName => {
                const field = form.querySelector(`[name="${fieldName}"]`);
                if (field) {
                    const error = validators[fieldName](field.value);
                    if (error) {
                        showFieldError(fieldName, error);
                        errors.push(error);
                        isValid = false;
                    }
                }
            });

            return { isValid, errors };
        }

        // Setup real-time validation
        setupRealTimeValidation();

        // Handle form submission
        form.addEventListener("submit", async function (e) {
            e.preventDefault();

            const { isValid, errors } = validateForm();
            
            if (!isValid) {
                // Show validation errors in SweetAlert
                await Swal.fire({
                    icon: "error",
                    title: "Please Check Your Form",
                    html: `
                        <div class="validation-errors">
                            <div class="error-summary" style="color: #dc3545; margin-bottom: 15px; font-weight: 500;">
                                Please correct the following errors before submitting:
                            </div>
                            <ul class="error-list" style="list-style-type: none; padding: 0; margin: 0; text-align: left;">
                                ${errors.map(error => `
                                    <li style="margin-bottom: 10px; padding-left: 25px; position: relative; color: #555;">
                                        <i class="fas fa-exclamation-circle" style="color: #dc3545; position: absolute; left: 0; top: 3px;"></i>
                                        ${error}
                                    </li>
                                `).join("")}
                            </ul>
                        </div>
                    `,
                    width: 500,
                    confirmButtonColor: "#1a3a6c",
                    customClass: {
                        popup: "swal2-show-validation-errors",
                        htmlContainer: "swal2-html-container-left-align",
                        confirmButton: "btn btn-primary",
                    },
                    showClass: {
                        popup: "animate__animated animate__fadeInDown",
                    },
                    hideClass: {
                        popup: "animate__animated animate__fadeOutUp",
                    },
                });

                // Scroll to first error
                const firstErrorField = form.querySelector('.is-invalid');
                if (firstErrorField) {
                    firstErrorField.scrollIntoView({ 
                        behavior: 'smooth', 
                        block: 'center' 
                    });
                }
                return;
            }

            // If form is valid, proceed with submission
            try {
                const submitBtn = form.querySelector("#send_form");
                const btnText = submitBtn.querySelector(".btn-text");
                const btnLoading = submitBtn.querySelector(".btn-loading");
                
                submitBtn.disabled = true;
                btnText.style.display = "none";
                btnLoading.style.display = "inline";

                const formData = new FormData(form);
                const response = await fetch(form.action, {
                    method: "POST",
                    body: formData,
                    headers: {
                        "X-Requested-With": "XMLHttpRequest",
                    },
                });

                const result = await response.json();

                if (response.ok && result.success) {
                    // Show success message
                    await Swal.fire({
                        icon: "success",
                        title: "Success!",
                        text: result.message || "Your message has been sent successfully!",
                        confirmButtonColor: "#1a3a6c",
                        timer: 3000,
                        timerProgressBar: true,
                    });

                    // Reset form and validation states
                    form.reset();
                    resetValidationState();
                    
                    // Reset character count
                    if (charCount) {
                        charCount.textContent = "0";
                        charCount.style.color = "#28a745";
                    }

                    // Refresh CSRF token
                    const csrfField = form.querySelector('input[name="csrf_test_name"]');
                    if (csrfField && result.csrf_token) {
                        csrfField.value = result.csrf_token;
                    }
                } else {
                    // Handle CSRF token issues
                    if (response.status === 403 || (result.message && result.message.includes("not allowed"))) {
                        await Swal.fire({
                            icon: "error",
                            title: "Session Expired",
                            text: "Please refresh the page and try again.",
                            confirmButtonColor: "#1a3a6c",
                        });
                        window.location.reload();
                        return;
                    }

                    // Show error message with specific details if available
                    let errorMessage = result.message || "Something went wrong. Please try again.";
                    
                    // If there are field-specific errors, show them
                    if (result.messages) {
                        Object.entries(result.messages).forEach(([field, message]) => {
                            showFieldError(field, message);
                        });
                        errorMessage = "Please check the form for errors and try again.";
                    }

                    await Swal.fire({
                        icon: "error",
                        title: "Submission Error",
                        text: errorMessage,
                        confirmButtonColor: "#1a3a6c",
                    });
                }
            } catch (error) {
                console.error("Submission error:", error);
                await Swal.fire({
                    icon: "error",
                    title: "Network Error",
                    text: "An unexpected error occurred. Please check your connection and try again.",
                    confirmButtonColor: "#1a3a6c",
                });
            } finally {
                const submitBtn = form.querySelector("#send_form");
                const btnText = submitBtn.querySelector(".btn-text");
                const btnLoading = submitBtn.querySelector(".btn-loading");
                
                submitBtn.disabled = false;
                btnText.style.display = "inline";
                btnLoading.style.display = "none";
            }
        });
    }
});
</script>


<?= $this->endSection() ?>