<?= $this->extend('website/index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
       <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Dynamic Block System for Business Banking Page -->
<?php if (!empty($page_blocks)): ?>
    <?php foreach ($page_blocks as $block): ?>
        
        <?php if ($block['block_type'] === 'overview'): ?>
        <!-- Overview Section with Side Image -->
        <section class="overview-section-image">
            <div class="container">
                <div class="side-image-layout">
                    <!-- Content Side -->
                    <div class="content-side">
                        <h2><?= renderEmphasized($block['heading'], $block['title_emphasized'] ?? '') ?></h2>
                        <p><?= esc($block['content']) ?></p>
                        
                        <?php if (!empty($block['items'])): ?>
                        <div class="info-cards-grid">
                            <?php foreach ($block['items'] as $item): ?>
                            <div class="info-card">
                                <div class="info-card-icon">
                                    <i class="<?= esc($item['icon']) ?>"></i>
                                </div>
                                <h3><?= esc($item['title']) ?></h3>
                                <p><?= esc($item['description']) ?></p>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Image Side - Dynamic -->
                    <div class="image-side">
                        <img src="<?= base_url('media/files/' . $block['photo']) ?>" alt="<?= esc($block['heading']) ?>">
                    </div>
                </div>
            </div>
        </section>
        
        <?php elseif ($block['block_type'] === 'info_cards'): ?>
        <!-- Business Banking Solutions Section -->
        <div class="join">
            <header>
                <h1><?= renderEmphasized($block['heading'], $block['title_emphasized'] ?? '') ?></h1>
                <p class="subtitle"><?= esc($block['subtitle']) ?></p>
            </header>
            
            <!-- Tab Navigation -->
            <div class="tabs-container">
                <div class="tabs">
                    <button class="tab-button active" data-category="sme-corporate">
                        <i class="fas fa-building"></i>
                        SME/Corporate
                        <span class="notification-badge"><?= $accounts_count ?></span>
                    </button>
                    <button class="tab-button" data-category="loans">
                        <i class="fas fa-hand-holding-usd"></i>
                        Loans
                        <span class="notification-badge"><?= $loans_count ?></span>
                    </button>
                    <button class="tab-button" data-category="investing">
                        <i class="fas fa-chart-line"></i>
                        Investing
                        <span class="notification-badge"><?= $trade_count ?></span>
                    </button>
                    <button class="tab-button" data-category="insurance">
                        <i class="fas fa-shield-alt"></i>
                        Insurance
                        <span class="notification-badge"><?= $insurance_count ?></span>
                    </button>
                </div>
            </div>
            
            <!-- Service Cards -->
            <?php if (!empty($block['items'])): ?>
                <!-- SME/Corporate Cards -->
                <div id="sme-corporate-cards" class="category-cards active">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'SME/Corporate'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Loans Cards -->
                <div id="loans-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Loans'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Investing Cards -->
                <div id="investing-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Investing'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- Insurance Cards -->
                <div id="insurance-cards" class="category-cards">
                    <div class="cards-container">
                        <?php foreach ($block['items'] as $item): ?>
                            <?php if ($item['caption'] === 'Insurance'): ?>
                            <div class="banking-card">
                                <div class="card-image">
                                    <img src="<?= base_url('media/files/' . $item['photo']) ?>" alt="<?= esc($item['title']) ?>">
                                    <div class="card-category"><?= esc($item['caption']) ?></div>
                                    <div class="card-overlay">
                                        <h3 class="card-title"><?= esc($item['title']) ?></h3>
                                        <a href="<?= base_url($item['link']) ?>" class="card-button">Learn More</a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
    <?php endforeach; ?>
<?php else: ?>
<!-- Fallback if no blocks found -->
<section class="hero-section">
    <img
        src="<?= base_url('assets/front_assets/images/save.webp') ?>"
        alt="Business Banking"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1>Business <span>Solutions</span></h1>
        <p>Empower your business with ABC Capital Bank. Explore our comprehensive range of Business banking solutions designed to fuel your growth.</p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>
