<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<style>
/* ===== VARIABLES ===== */
:root {
    --primary-color: #0d6efd;
    --primary-dark: #0b5ed7;
    --secondary-color: #6c757d;
    --success-color: #198754;
    --danger-color: #dc3545;
    --light-color: #f8f9fa;
    --dark-color: #212529;
    --border-radius: 0.375rem;
    --box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --transition: all 0.3s ease;
}

/* ===== DOWNLOADS SECTION ===== */
.downloads-section {
    padding: 2rem 0;
}

.downloads-card {
    box-shadow: var(--box-shadow);
    border: none;
    border-radius: var(--border-radius);
    background-color: #fff;
    transition: var(--transition);
    overflow: hidden;
}

.downloads-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.downloads-card-body {
    padding: 1.5rem;
}

.downloads-card-header {
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.downloads-card-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-color);
    margin: 0;
}

.downloads-table {
    width: 100%;
    margin-bottom: 0;
    border-collapse: collapse;
}

.downloads-table thead {
    background-color: var(--light-color);
}

.downloads-table th {
    text-transform: uppercase;
    color: var(--secondary-color);
    font-weight: 600;
    font-size: 0.85rem;
    padding: 0.75rem;
    border-bottom: 1px solid #dee2e6;
}

.downloads-table td {
    padding: 0.75rem;
    vertical-align: middle;
    border-bottom: 1px solid #dee2e6;
    transition: var(--transition);
}

.downloads-table tbody tr:hover td {
    background-color: rgba(13, 110, 253, 0.05);
}

.downloads-table .file-icon {
    font-size: 1.25rem;
    margin-right: 0.5rem;
    color: var(--primary-color);
}

.downloads-table .file-title {
    font-weight: 600;
    color: var(--dark-color);
}

.downloads-table .file-date {
    color: var(--secondary-color);
    font-size: 0.875rem;
}

.downloads-btn {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #fff;
    background-color: var(--primary-color);
    border: 1px solid var(--primary-color);
    border-radius: 50rem;
    text-decoration: none;
    transition: var(--transition);
}

.downloads-btn:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    color: #fff;
    transform: translateY(-2px);
}

/* ===== STATUS BADGES ===== */
.status-badge {
    display: inline-block;
    padding: 0.25rem 0.5rem;
    font-size: 0.75rem;
    font-weight: 600;
    border-radius: 50rem;
    text-transform: uppercase;
}

.status-active {
    background-color: #d1e7dd;
    color: #0f5132;
}

.status-closed {
    background-color: #f8d7da;
    color: #721c24;
}

.status-upcoming {
    background-color: #fff3cd;
    color: #856404;
}

/* ===== TENDER DETAILS ===== */
.tender-details {
    background-color: #f8f9fa;
    border-radius: var(--border-radius);
    padding: 1rem;
    margin-bottom: 1rem;
}

.tender-info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 1rem;
}

.tender-info-item {
    display: flex;
    flex-direction: column;
}

.tender-info-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: var(--secondary-color);
    text-transform: uppercase;
    margin-bottom: 0.25rem;
}

.tender-info-value {
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--dark-color);
}

/* ===== RESPONSIVE ADJUSTMENTS ===== */
@media (max-width: 991.98px) {
    .calculator-card {
        margin-top: 2rem;
    }
}

@media (max-width: 575.98px) {
    .downloads-card-body,
    .calculator-card-body {
        padding: 1rem;
    }
    
    .tender-info-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<!-- Page Content -->
<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Content Area -->
<section class="downloads-section py-5">
    <div class="container">
        <div class="row">
            <!-- Bids & Tenders Section -->
            <div class="col-lg-12">
                <div class="downloads-card">
                    <div class="downloads-card-body">
                        <div class="downloads-card-header">
                            <h2 class="downloads-card-title">Current Bids & Tenders</h2>
                            <p class="text-muted mb-0">Explore current bidding opportunities and tender notices. Partner with ABC Capital Bank in delivering quality services and projects through our procurement processes.</p>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-8">
                                <div class="alert alert-warning">
                                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                    <strong>Important:</strong> All bids must be submitted before the specified deadline. Late submissions will not be considered.
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="bg-light p-4 rounded">
                                    <h5 class="mb-3">Procurement Department</h5>
                                    <p class="mb-2"><i class="bi bi-telephone me-2"></i> +256 200 516 600</p>
                                    <p class="mb-2"><i class="bi bi-envelope me-2"></i> procurement@abccapitalbank.co.ug</p>
                                    <p class="mb-0"><i class="bi bi-clock me-2"></i> Mon-Fri: 8:00 AM - 5:00 PM</p>
                                </div>
                            </div>
                        </div>

                        <?php if (!empty($tenders)): ?>
                            <div class="table-responsive">
                                <table id="bidsTendersTable" class="downloads-table">
                                    <thead>
                                        <tr>
                                            <th scope="col">Tender Title</th>
                                            <th scope="col">Reference No.</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Deadline</th>
                                            <th scope="col">Documents</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($tenders as $tender): ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <?php
                                                        $fileExtension = pathinfo($tender->file ?? '', PATHINFO_EXTENSION);
                                                        $iconClass = 'bi-file-earmark-text';
                                                        ?>
                                                        <i class="bi <?= $iconClass ?>-fill file-icon text-primary"></i>
                                                        <div class="d-inline-block align-middle">
                                                            <div class="file-title"><?= esc($tender->title) ?></div>
                                                            <?php if (!empty($tender->excerpt)): ?>
                                                                <small class="file-date"><?= esc($tender->excerpt) ?></small>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <code class="text-muted small"><?= esc($tender->alias ?? 'N/A') ?></code>
                                                </td>
                                                <td>
                                                    <?php
                                                    // Determine status based on dates or other criteria
                                                    $status = 'active';
                                                    $statusClass = 'status-active';
                                                    $statusText = 'Active';
                                                    ?>
                                                    <span class="status-badge <?= $statusClass ?>"><?= $statusText ?></span>
                                                </td>
                                                <td>
                                                    <small class="file-date fw-medium"><?= esc(date('M j, Y', strtotime($tender->created_at))) ?></small>
                                                </td>
                                                <td>
                                                    <?php if (!empty($tender->file)): ?>
                                                        <a href="<?= base_url('media/files/' . $tender->file) ?>" class="downloads-btn" target="_blank" title="Download Tender Documents">
                                                            <i class="bi bi-download me-1"></i>Download
                                                        </a>
                                                    <?php else: ?>
                                                        <span class="text-muted small">Documents Coming Soon</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-clipboard-check display-1 text-muted"></i>
                                <p class="mt-3 text-muted">No current bids or tenders available.</p>
                                <p>Please check back later for new procurement opportunities.</p>
                            </div>
                        <?php endif; ?>

                        <!-- Bidding Guidelines -->
                        <div class="mt-5 pt-4 border-top">
                            <h5 class="mb-3">Bidding Guidelines</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Read tender documents carefully
                                        </li>
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Submit all required documents
                                        </li>
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Meet all eligibility criteria
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Adhere to submission deadlines
                                        </li>
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Provide accurate information
                                        </li>
                                        <li class="list-group-item d-flex align-items-center">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            Follow specified format requirements
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
// Initialize DataTable for bids & tenders
$(document).ready(function () {
    $('#bidsTendersTable').DataTable({
        pageLength: 10,
        order: [[3, "desc"]], // Sort by deadline descending
        language: {
            search: "Search tenders:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ tenders",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        },
        responsive: true,
        columnDefs: [
            {
                targets: [2], // Status column
                orderable: false
            }
        ]
    });
});
</script>

<?= $this->endSection() ?>