<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<style>
/* ===== VARIABLES ===== */
:root {
    --primary-color: #0d6efd;
    --primary-dark: #0b5ed7;
    --secondary-color: #6c757d;
    --success-color: #198754;
    --danger-color: #dc3545;
    --light-color: #f8f9fa;
    --dark-color: #212529;
    --border-radius: 0.375rem;
    --box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --transition: all 0.3s ease;
}

/* ===== DOWNLOADS SECTION ===== */
.downloads-section {
    padding: 2rem 0;
}

.downloads-card {
    box-shadow: var(--box-shadow);
    border: none;
    border-radius: var(--border-radius);
    background-color: #fff;
    transition: var(--transition);
    overflow: hidden;
}

.downloads-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.downloads-card-body {
    padding: 1.5rem;
}

.downloads-card-header {
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.downloads-card-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-color);
    margin: 0;
}

.downloads-table {
    width: 100%;
    margin-bottom: 0;
    border-collapse: collapse;
}

.downloads-table thead {
    background-color: var(--light-color);
}

.downloads-table th {
    text-transform: uppercase;
    color: var(--secondary-color);
    font-weight: 600;
    font-size: 0.85rem;
    padding: 0.75rem;
    border-bottom: 1px solid #dee2e6;
}

.downloads-table td {
    padding: 0.75rem;
    vertical-align: middle;
    border-bottom: 1px solid #dee2e6;
    transition: var(--transition);
}

.downloads-table tbody tr:hover td {
    background-color: rgba(13, 110, 253, 0.05);
}

.downloads-table .file-icon {
    font-size: 1.25rem;
    margin-right: 0.5rem;
    color: var(--primary-color);
}

.downloads-table .file-title {
    font-weight: 600;
    color: var(--dark-color);
}

.downloads-table .file-date {
    color: var(--secondary-color);
    font-size: 0.875rem;
}

.downloads-btn {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #fff;
    background-color: var(--primary-color);
    border: 1px solid var(--primary-color);
    border-radius: 50rem;
    text-decoration: none;
    transition: var(--transition);
}

.downloads-btn:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    color: #fff;
    transform: translateY(-2px);
}

/* ===== CALCULATOR SECTION ===== */
.calculator-card {
    box-shadow: var(--box-shadow);
    border: none;
    border-radius: var(--border-radius);
    background-color: #fff;
    transition: var(--transition);
    overflow: hidden;
}

.calculator-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.calculator-card-body {
    padding: 1.5rem;
}

.calculator-card-header {
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.calculator-card-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--dark-color);
    margin: 0;
}

.form-group {
    margin-bottom: 1.25rem;
    position: relative;
}

.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: var(--dark-color);
}

.form-control {
    width: 100%;
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    border: 1px solid #ced4da;
    border-radius: var(--border-radius);
    transition: var(--transition);
}

.form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}

.form-control:disabled {
    background-color: #e9ecef;
    opacity: 1;
}

.btn-calculate {
    width: 100%;
    padding: 0.75rem;
    font-size: 1rem;
    font-weight: 600;
    color: #fff;
    background-color: var(--primary-color);
    border: 1px solid var(--primary-color);
    border-radius: var(--border-radius);
    transition: var(--transition);
    cursor: pointer;
}

.btn-calculate:hover {
    background-color: var(--primary-dark);
    border-color: var(--primary-dark);
    transform: translateY(-2px);
}

.btn-calculate:active {
    transform: translateY(0);
}

/* ===== LOADING SPINNER ===== */
.loading-spinner {
    display: inline-block;
    width: 2rem;
    height: 2rem;
    border: 0.25em solid #f3f3f3;
    border-top: 0.25em solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* ===== RESULTS SECTION ===== */
.results-section {
    margin-top: 1.5rem;
    padding-top: 1.5rem;
    border-top: 1px solid #e9ecef;
}

.results-group {
    margin-bottom: 1rem;
}

.results-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: var(--dark-color);
}

.input-group {
    display: flex;
    border-radius: var(--border-radius);
    overflow: hidden;
}

.input-group input {
    flex: 1;
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
    border-right: none;
}

.input-group span {
    padding: 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #e9ecef;
    border: 1px solid #ced4da;
    min-width: 60px;
    text-align: center;
}

/* ===== ERROR MESSAGES ===== */
.alert {
    padding: 0.75rem 1rem;
    margin-bottom: 1rem;
    border: 1px solid transparent;
    border-radius: var(--border-radius);
}

.alert-danger {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

/* ===== RESPONSIVE ADJUSTMENTS ===== */
@media (max-width: 991.98px) {
    .calculator-card {
        margin-top: 2rem;
    }
}

@media (max-width: 575.98px) {
    .downloads-card-body,
    .calculator-card-body {
        padding: 1rem;
    }
    
    .input-group {
        flex-direction: column;
    }
    
    .input-group input {
        border-right: 1px solid #ced4da;
        border-bottom: none;
    }
    
    .input-group span {
        border-top: none;
    }
}
</style>

<!-- Page Content -->
<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Content Area -->
<section class="downloads-section py-5">
    <div class="container">
        <div class="row">
            <!-- Annual Reports Section -->
            <div class="col-lg-12">
                <div class="downloads-card">
                    <div class="downloads-card-body">
                        <div class="downloads-card-header">
                            <h2 class="downloads-card-title">Annual Financial Reports</h2>
                            <p class="text-muted mb-0">Access our comprehensive annual reports and financial statements. Stay informed about our performance, growth, and financial health over the years.</p>
                        </div>

                        <?php if (!empty($reports)): ?>
                            <div class="alert alert-info mb-4">
                                <i class="bi bi-info-circle-fill me-2"></i>
                                <strong>Note:</strong> Annual reports are available for download in PDF format. For earlier years not listed, please contact our customer service.
                            </div>

                            <div class="table-responsive">
                                <table id="annualReportsTable" class="downloads-table">
                                    <thead>
                                        <tr>
                                            <th scope="col">Report Title</th>
                                            <th scope="col">Description</th>
                                            <th scope="col">Date Published</th>
                                            <th scope="col">Download</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($reports as $report): ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <?php
                                                        $fileExtension = pathinfo($report->file ?? '', PATHINFO_EXTENSION);
                                                        $iconClass = 'bi-file-earmark-pdf';
                                                        ?>
                                                        <i class="bi <?= $iconClass ?>-fill file-icon text-danger"></i>
                                                        <div class="d-inline-block align-middle">
                                                            <div class="file-title"><?= esc($report->title) ?></div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <?php if (!empty($report->excerpt)): ?>
                                                        <p class="mb-0 text-muted small"><?= esc($report->excerpt) ?></p>
                                                    <?php else: ?>
                                                        <span class="text-muted small">Annual Financial Report</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <small class="file-date fw-medium"><?= esc(date('F j, Y', strtotime($report->created_at))) ?></small>
                                                </td>
                                                <td>
                                                    <?php if (!empty($report->file)): ?>
                                                        <a href="<?= base_url('media/files/' . $report->file) ?>" class="downloads-btn" target="_blank" title="Download PDF Report">
                                                            <i class="bi bi-download me-1"></i>Download PDF
                                                        </a>
                                                    <?php else: ?>
                                                        <span class="text-muted small">Coming Soon</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-file-earmark-pdf display-1 text-muted"></i>
                                <p class="mt-3 text-muted">No annual reports available at the moment.</p>
                                <p>Please check back later or contact us for specific report requests.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
// Initialize DataTable for annual reports
$(document).ready(function () {
    $('#annualReportsTable').DataTable({
        pageLength: 10,
        order: [[2, "desc"]], // Sort by date descending
        language: {
            search: "Search reports:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ reports",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        },
        responsive: true
    });
});
</script>

<?= $this->endSection() ?>