<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img 
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>" 
        alt="<?= esc($hero_banner['name']) ?>" 
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Dynamic Block System for About Us Page -->
<?php if (!empty($templateData)): ?>

    <?php if (!empty($templateData['journey'])): ?>
    <!-- Journey Section -->
    <div class="section1" id="journey">
        <div class="container">
            <div class="section-title">
                <h2><?= renderEmphasized($templateData['journey']['title'], $templateData['journey']['title_emphasized'] ?? '') ?></h2>
                <p><?= esc($templateData['journey']['subtitle']) ?></p>
            </div>
            <div class="journey-grid">
                <?php if (!empty($templateData['journey']['items'])): ?>
                    <?php foreach ($templateData['journey']['items'] as $item): ?>
                    <div class="journey-card">
                        <h3><?= esc($item['title']) ?></h3>
                        <p><?= esc($item['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($templateData['vision_mission'])): ?>
    <!-- Vision & Mission Section -->
    <div class="section1 values-section" style="padding:30px 0;">
        <div class="container">
            <div class="section-title">
                <h2><?= renderEmphasized($templateData['vision_mission']['title'], $templateData['vision_mission']['title_emphasized'] ?? '') ?></h2>
                <p><?= esc($templateData['vision_mission']['subtitle']) ?></p>
            </div>
            <div class="journey-grid">
                <?php if (!empty($templateData['vision_mission']['items'])): ?>
                    <?php foreach ($templateData['vision_mission']['items'] as $item): ?>
                    <div class="journey-card">
                        <h3><?= esc($item['title']) ?></h3>
                        <p><?= esc($item['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($templateData['values'])): ?>
    <!-- Values Section -->
    <div class="section1">
        <div class="container">
            <div class="section-title">
                <h2><?= renderEmphasized($templateData['values']['title'], $templateData['values']['title_emphasized'] ?? '') ?></h2>
                <p><?= esc($templateData['values']['subtitle']) ?></p>
            </div>
            <div class="values-grid">
                <?php if (!empty($templateData['values']['items'])): ?>
                    <?php foreach ($templateData['values']['items'] as $item): ?>
                    <div class="value-item">
                        <div class="value-icon"><?= esc($item['icon']) ?></div>
                        <h4><?= esc($item['title']) ?></h4>
                        <p><?= esc($item['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($templateData['goals'])): ?>
    <!-- Goals Section -->
    <div class="section1 goals-section" style="padding:30px 0;">
        <div class="container">
            <div class="goals-container">
                <div class="goals-content">
                    <h2><?= renderEmphasized($templateData['goals']['title'], $templateData['goals']['title_emphasized'] ?? '') ?></h2>
                    <?php if (!empty($templateData['goals']['items'])): ?>
                    <ul class="goals-list">
                        <?php foreach ($templateData['goals']['items'] as $item): ?>
                        <li><?= esc($item['title']) ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                </div>
                <div class="goals-visual">
                    <div class="digital-badge">
                        <h3>Digital First</h3>
                        <p>Banking that seamlessly fits into your daily life and expectations through advanced technology and innovative solutions.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($templateData['benefits'])): ?>
    <!-- Benefits Section -->
    <div class="section1">
        <div class="container">
            <div class="section-title">
                <h2><?= renderEmphasized($templateData['benefits']['title'], $templateData['benefits']['title_emphasized'] ?? '') ?></h2>
                <p><?= esc($templateData['benefits']['subtitle']) ?></p>
            </div>
            <div class="journey-grid">
                <?php if (!empty($templateData['benefits']['items'])): ?>
                    <?php foreach ($templateData['benefits']['items'] as $item): ?>
                    <div class="journey-card">
                        <h3><?= esc($item['title']) ?></h3>
                        <p><?= esc($item['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (!empty($templateData['contact'])): ?>
    <!-- Contact Section -->
    <div class="contact-section">
        <div class="container">
            <div class="contact-info">
                <h3><?= renderEmphasized($templateData['contact']['title'], $templateData['contact']['title_emphasized'] ?? '') ?></h3>
                <p><?= esc($templateData['contact']['subtitle']) ?></p>
                <?php if (!empty($templateData['contact']['numbers'])): ?>
                <div class="contact-numbers">
                    <?php foreach ($templateData['contact']['numbers'] as $number): ?>
                    <div class="contact-number"><?= esc($number['value']) ?></div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php endif; ?>

<script>
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Intersection Observer for animations
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observe all cards and sections
    document.querySelectorAll('.journey-card, .value-item').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(30px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });
</script>

<?= $this->endSection() ?>