<!DOCTYPE html>
<?php 
	$default_title = 'ABC Capital Bank - Uganda\'s Digital-Led Financial Solutions Provider';
	$default_meta_description = 'ABC Capital Bank is a digital-led Tier 2 bank in Uganda, transitioning from its origins as Capital Finance Corporation in 1993. We offer seamless, customer-centric banking solutions for Retail & SME segments, focusing on digital payments, electronic loans, savings, and personalized services.';
	$default_meta_keywords = 'ABC Capital Bank, ABC Bank Uganda, digital bank Uganda, SME banking Uganda, retail banking Uganda, Capital Finance Corporation, CFC Ltd, Bank of Uganda, financial solutions, digital payments, electronic loans, Uganda banking, financial technology, FinTech Uganda';
	$default_image=   base_url('assets/front_assets/images/abc-logo.png');
?>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title> <?php  echo $title;  ?></title>
	<meta name="description" content="
      <?php if (!empty($description)) { echo $description;} else {echo $default_meta_description;}?>
    ">
    <meta name="keywords" content="
      <?php
        $final_keywords = $keywords ?? $default_meta_keywords;
        if (!empty($tags) && is_array($tags)) {
          $tag_names = array_column($tags, 'name');
          $final_keywords .= ', ' . implode(', ', $tag_names);
        }
        echo $final_keywords;
      ?>
    ">
    <meta property="og:title" content=" <?php if (!empty($title)) {echo $title;} else {echo $default_title;} ?> "/>
    <meta property="og:description" content="
      <?php if (!empty($description)) { echo $description;} else {echo $default_meta_description;}?>
    "/>
    <meta property="og:image" content="
      <?php if (!empty($featured_image)) {echo $featured_image;} else {echo base_url('assets/front_assets/images/abc-logo.png');} ?>
    " />
    <meta property="og:url" content="<?php echo current_url(); ?>" />
    <meta name="twitter:title" content=" <?php if (!empty($title)) {echo $title;} else {echo $default_title;} ?>"/>
    <meta name="twitter:description" content="
      <?php if (!empty($description)) { echo $description;} else {echo $default_meta_description;}?>
    "/>
    <meta name="twitter:image" content="
      <?php if (!empty($featured_image)) {echo $featured_image;} else {echo base_url('assets/front_assets/images/abc-logo.png');} ?>
    "/>

    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo current_url(); ?>" />

    <!-- Robots Meta Tag -->
    <meta name="robots" content="index, follow" />

    <!-- Favicon -->
    <link href="<?= base_url('assets/front_assets/favicon.ico'); ?>" rel="icon">
    <link href="<?= base_url('assets/front_assets/apple-touch-icon.png'); ?>" rel="apple-touch-icon">
    <link href="<?= base_url('assets/front_assets/favicon-32x32.png'); ?>" rel="icon" type="image/png" sizes="32x32">
    <link href="<?= base_url('assets/front_assets/favicon-16x16.png'); ?>" rel="icon" type="image/png" sizes="16x16">

	<!-- Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:wght@100;300;400;500;700;900&family=Merriweather:wght@300;400;700;900&display=swap" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?= base_url('assets/front_assets/vendor/bootstrap/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="<?= base_url('assets/front_assets/css/custom.css'); ?>">
    <link rel="stylesheet" href="<?= base_url('assets/front_assets/css/news-cards.css'); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    
    <!-- AOS CSS -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/front_assets/vendor/aos/aos.css'); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

    <!-- Scripts -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script src="<?= base_url('assets/front_assets/js/preloader.js'); ?>"></script>


    <!-- Gallery -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />
</head>

<body>
<script>
if (typeof start_load === 'function') {
    start_load();
}
</script>
