<?= $this->extend('website/footer_pages/base_footer_page'); ?>

<?= $this->section('page_content'); ?>

<div class="faqs-content">
    <h2>Frequently Asked Questions</h2>
    
    <p class="lead">Find answers to the most commonly asked questions about our banking services.</p>
    
    <div class="faq-accordion mt-4">
        <div class="accordion" id="faqAccordion">
            
            <!-- General Banking -->
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading1">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1">
                        How do I open a bank account?
                    </button>
                </h2>
                <div id="collapse1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        To open a bank account, visit any of our branches with a valid ID, proof of address, and initial deposit. Our staff will guide you through the process and help you choose the right account type for your needs.
                    </div>
                </div>
            </div>
            
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading2">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2">
                        What are your banking hours?
                    </button>
                </h2>
                <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Our branches are open Monday to Friday from 8:00 AM to 5:00 PM, and Saturdays from 8:00 AM to 1:00 PM. ATM services are available 24/7.
                    </div>
                </div>
            </div>
            
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading3">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3">
                        How can I check my account balance?
                    </button>
                </h2>
                <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        You can check your account balance through our mobile app, internet banking, ATMs, or by visiting any branch. You can also call our customer service line for balance inquiries.
                    </div>
                </div>
            </div>
            
            <!-- Loans -->
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading4">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4">
                        What documents do I need for a loan application?
                    </button>
                </h2>
                <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Loan requirements vary by type, but generally include: valid ID, proof of income, bank statements, collateral documents (if applicable), and completed application form. Our loan officers will provide a complete list based on your specific needs.
                    </div>
                </div>
            </div>
            
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading5">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5">
                        How long does loan approval take?
                    </button>
                </h2>
                <div id="collapse5" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Loan approval times vary depending on the loan type and amount. Personal loans typically take 3-5 business days, while mortgage loans may take 2-3 weeks. We'll keep you informed throughout the process.
                    </div>
                </div>
            </div>
            
            <!-- Digital Banking -->
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading6">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6">
                        How do I register for mobile banking?
                    </button>
                </h2>
                <div id="collapse6" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Download our mobile app from the App Store or Google Play, then follow the registration process using your account number and phone number. You can also register at any branch or call our customer service for assistance.
                    </div>
                </div>
            </div>
            
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading7">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse7">
                        Is mobile banking secure?
                    </button>
                </h2>
                <div id="collapse7" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Yes, our mobile banking platform uses advanced encryption and security measures to protect your information. We recommend using strong passwords, not sharing your login details, and logging out after each session.
                    </div>
                </div>
            </div>
            
            <!-- Fees and Charges -->
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading8">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse8">
                        What are your account maintenance fees?
                    </button>
                </h2>
                <div id="collapse8" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        Account maintenance fees vary by account type. Please visit our branches or check our website for the current fee schedule. Many fees can be waived by maintaining minimum balances or meeting other requirements.
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    
    <div class="mt-5">
        <h3>Still Have Questions?</h3>
        <p>If you couldn't find the answer to your question, please don't hesitate to contact us:</p>
        <ul class="contact-options">
            <li><i class="fas fa-phone"></i> Call us at +1 (800) 123-4567</li>
            <li><i class="fas fa-envelope"></i> Email us at info@abccapitalbank.com</li>
            <li><i class="fas fa-map-marker-alt"></i> Visit any of our branches</li>
        </ul>
    </div>
</div>

<?= $this->endSection(); ?>
