<?php
// Define variables passed from the controller
$clientName     = isset($clientName) ? $clientName : '';
$response       = isset($response) ? $response : '';
$messageId      = isset($messageId) ? $messageId : '';
$originalMessage = isset($originalMessage) ? $originalMessage : '';
$respondedBy    = isset($respondedBy) ? $respondedBy : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700&family=Montserrat:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">

    <title>Response to Your Contact Form Message - ABC Capital Bank</title>
	<style>
	html,body{font-family: "Montserrat", sans-serif !important;font-size:14px;color:#333 !important;padding-top:2%;background:#dee8f1;}
	.pdetails{border: 0px;width:100%;font-size:13px;}
	.pdetails td{line-height:24px;border-bottom: 1px solid #ede3e3;}
	.container{margin:0 auto; width:70%;min-width:360px;padding:15px;background:#fff;border-top:3px solid #ba2d2d;}
	a{text-decoration: none;}
	.btn{display: inline-block; background:#ba2d2d;color:#fff;font-size:16px;padding:10px;border-radius:10px;border:0px;width:40%;text-align:center;}
	.response-box{background:#e8f5e8;padding:15px;border-left:4px solid #28a745;margin:15px 0;}
	.original-message{background:#f8f9fa;padding:15px;border-left:4px solid #6c757d;margin:15px 0;}
	</style>
</head>
<body>
	<div class="container" style="background:#fff;padding: 20px;">
		<div style="margin-bottom:5px;"><a href="https://www.abccapitalbank.co.ug" target="_blank"><img src="https://abccapitalbank.co.ug/logo-mobile.png" height="50px"/></a></div>
		<div style="padding: 20px;">
				<h3 style="font-size:18px;font-weight:600">Response to Your Contact Form Message</h3>
				<hr/>

				<p>Hello <?php echo htmlspecialchars($clientName); ?>,</p>

				<p>We have responded to your message submitted through our contact form.</p>

				<p><strong>Message Reference ID:</strong> <?php echo htmlspecialchars($messageId); ?></p>

				<?php if (!empty($originalMessage)): ?>
				<div class="original-message">
					<strong>Your Original Message:</strong><br/>
					<?php echo nl2br(htmlspecialchars($originalMessage)); ?>
				</div>
				<?php endif; ?>

				<div class="response-box">
					<strong>Our Response:</strong><br/>
					<?php echo nl2br(htmlspecialchars($response)); ?>
				</div>

				<p>If you have any further questions, please don't hesitate to contact us again.</p>

				<p>For urgent matters, please call our customer care line at +256 414 301 000.</p>

				<p style="color: #555;font-size:12px"> Regards,<br/>
                ABC Capital Bank Customer Care Team<br/>
				<small>Responded by: <?php echo htmlspecialchars($respondedBy); ?><br/>
				<?= date('jS, M Y H:i:s');?></small>
				</p>
		</div>
	</div>
</div>
</body>
</html>
