<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4><?= $member->title; ?>'s Profile</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/team/members') ?> ">Team Members</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<div class="row">
    <div class="col-lg-10 col-md-10 col-sm-10">
        <div class="card card-body mb-3">
            <h4 class="fw-bold"><?= $member->title; ?></h4>
            <span class="d-flex"><small><strong>Date:</strong> <?= date('jS M Y', strtotime($member->created_at)); ?>   | <strong>Category:</strong> <?= $member->category_name; ?> | <strong>Hits:</strong> <span class="badge bg-danger bg-opacity-50"><?= $member->hits; ?></span> </small></span>

			
            <hr/>
            <div class="row mb-3">
                <div class="col-lg-6 col-md-6 col-sm-6"><img src="<?= esc($member->photo_url ?: base_url('assets/images/placeholder.png')); ?>" alt="" class="img-fluid" /></div>
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <table class="table">
                        <tr><td><strong>Position:</strong></td><td><?= $member->position; ?></td></tr>
                        <tr><td><strong>Date of Birth:</strong></td><td><?= date('jS M Y', strtotime($member->birthday)); ?></td></tr>
                        <tr><td><strong>Relationship Status:</strong></td><td><?= $member->relationship_status; ?></td></tr>
                    </table>
                    
                    <p><strong>Brief:</strong><br> <span class="text-muted"><?= $member->excerpt; ?></span></p>

                </div>
            </div>

            <h4 class="fw-bold">>>Achievements</h6><hr/>
            <?= $member->achievements; ?>

            <h4 class="fw-bold"> >>Full Bio</h6><hr/>
            <?= $member->content ?>
            <p>Died: <?= $member->died_at; ?></p>
        </div> <!-- Post Content !-->
    </div>
    <div class="col-lg-2 col-md-2 col-sm-2">
        <a href="<?= base_url('administrator/team/members'); ?>" class="btn btn-sm btn-secondary mb-3 w-100">Back to Team Members</a>
        <a href="<?= base_url('administrator/team/member/edit/').$member->id.'-'.$member->alias; ?>" class="btn btn-sm btn-info mb-3 w-100">Edit Member Details</a>
        <a href="<?= base_url('administrator/team/member/add/'); ?>" class="btn btn-sm btn-primary mb-3 w-100">Add New Member</a>
        <a href="#" class="btn btn-sm bg-warning bg-opacity-50 mb-3 w-100">Photo Gallery</a>
    </div>
</div>

<!-- End Create/Post !-->
<!-- Modals !-->

<!---- JS --->
<script src="<?= base_url();?>/assets/js/modules/teams.js"></script>  
<?= $this->endSection();?>