<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Add Member Profile</h4>
            <!-- Breadcrumb !-->
            <nav aria-label="breadcrumb"><small>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator/team/members') ?> ">Team Members</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
                </ol></small>
            </nav>
        </div>  
    </div><!-- End Breadcrumb !-->
    <div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <div id="showMsg"></div>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
    </div></div><!-- Error Display !-->
<div class="row">
    <form method="POST" action="<?= base_url('administrator/team/member/add')?>" enctype="multipart/form-data">
        <?= csrf_field();?>
   
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> Save & Close</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <a href="<?= base_url('administrator/team/members') ?>" class="btn btn-sm btn-primary">Back to Members</a>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->

    <div class="row g-2">
        <div class="col-lg-9">
            <div class="card card-body">
                <div class="row mb-3">
                    <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                        <label class="form-label fw-bold" for="mainphoto">Add Member Photo <br/><span style="font-size: 11px; color: #666">Please ensure image is less than 1MB in size</span></label>
                        <div style="min-height: 200px; background: #F2F9FF; border-radius: 0px;">
                        <div id="postImgPreview"></div>

                        <input type="file" name="photo" id="post_image" class="postImg upload-photo"   accept="image/jpeg,image/jpg,image/gif,image/png,image/webp," required/>
                        </div>
                    </div><!-- photo !-->
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="mb-3">
                            <input type="text" name="title" placeholder="Enter Full Name" class="form-control rounded-0" id="Name" required/>
                        </div><!-- Name !-->
                        <div class="mb-3">
                            <input type="text" name="title" placeholder="Enter Full Name" class="form-control rounded-0" id="Name" required/>
                        </div><!-- Name !-->
                        <div class="mb-3">
                            <input type="text" name="position" placeholder="Job Title" class="form-control rounded-0" id="Title" required/>
                        </div><!-- Position !-->
                        <div class="mb-3">
                            <?php function generateSelectOptions($categories, $indent = '') { ?>
                                <?php foreach ($categories as $category) { ?>
                                    <option value="<?= $category['id'] ?>"><?= $indent . $category['name'] ?></option>
                                    <?php if (isset($category['subcategories']) && is_array($category['subcategories'])) { ?>
                                        <?php generateSelectOptions($category['subcategories'], $indent . '- '); ?>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>
                            <select name="category_id" class="form-select rounded-0" required>
                                <option value="">Select Team Category</option>
                                <?php generateSelectOptions($categoryTree); ?>
                            </select>
                        </div><!-- Category !-->
                        <div class="mb-3">
                            <textarea name="excerpt" class="form-control rounded-0" placeholder="Provide a brief about the Member (Max 250 words)" rows="3" maxlength="250"></textarea>
                        </div><!-- Brief About - Member !-->
                    </div><!-- Name Details !-->
                </div><!-- row !-->
                <div class="accordion accordion-flush" id="accordionFlushDetails">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-primary bg-opacity-25 text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                            Add More Member Details (optional)
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushDetails">
                            <div class="accordion-body">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-4  mb-3">
                                        <label class="form-label fw-bold" for="bDay">Birthday</label>
                                        <input type="date" name="birthday" class="form-control rounded-0" id="bDay" />
                                    </div><!-- Birthday !-->
                                    <div class="col-lg-4 col-md-4 col-sm-4  mb-3">
                                        <label class="form-label fw-bold" for="relationship">Select Relationship</label>
                                        <select name="relationship_status" class="form-select rounded-0" id="relationship">
                                            <option value="Single">Single</option>
                                            <option value="Married">Married</option>
                                            <option value="Divorced">Divorced</option>
                                            <option value="Widow">Widow</option>
                                        </select>
                                    </div><!-- Relationship !-->
                                    <div class="col-lg-4 col-md-4 col-sm-4 mb-3">
                                        <label class="form-label fw-bold" for="link">Website</label>
                                        <input type="text" name="urls" class="form-control rounded-0" id="link" />
                                    </div><!-- Website !-->
                                    <div class="col-lg-12  mb-3">
                                        <label class="form-label fw-bold" for="goals">Member's Achievements</label>
                                        <textarea type="text" name="achievements" class="form-control rounded-0" id="tiny"></textarea>
                                    </div><!-- Achievements !-->
                                    <div class="col-lg-12  mb-3">
                                        <label class="form-label fw-bold" for="bio">Full Bio</label>
                                        <textarea type="text" name="content" class="form-control rounded-0" id="tiny"></textarea>
                                    </div><!-- Achievements !-->
                                    <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                                        <label class="form-label fw-bold" for="da">Died On <br/><small class="fw-lighter">(This option is only necessary for celebrity Talk and life Magazine.)</small></label>
                                        <input type="date" name="died_at" class="form-control rounded-0" id="da" />
                                    </div><!-- Website !-->

                                </div><!-- Row !-->
                            </div><!-- Accordion Body !-->
                        </div>
                    </div>
                </div><!-- End According for More Details !-->

            </div><!-- card !-->
        </div><!-- Col LEFT !-->
        <div class="col-lg-3">
            <div class="card card-body">
                <div class="mb-3">
                    <label for="ordering">Display Order</label>
                    <select name="ordering" class="form-control">
                        <?php for($i = 1; $i <= 20; $i++): ?>
                            <option value="<?= $i ?>" <?= (old('ordering', $member->ordering ?? '') == $i) ? 'selected' : '' ?>>
                                Position <?= $i ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div><!-- Ordering !-->
                <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white" >
                        <option value="Published" >Published</option>
                        <option value="Unpublished">Unpublished</option>
                        <option value="Archived">Archived</option>
                        <option value="Trashed">Trashed</option>
                    </select>
                  </div><!-- Status of publishing !-->
                <p>Only provide team member's social handle <small class="text-muted">E.g "lwegatech"</small></p>
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="instagram" style="background: #fa7e1e; color: #fff;"><i class="bi bi-instagram"></i></span>
                    <input type="text" name="instagram" class="form-control rounded-0" placeholder="Instagram" aria-label="Instagram" aria-describedby="social">
                </div><!-- Instagram !-->
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="twitter" style="background: #000; color: #fff;"><i class="bi bi-twitter-x"></i></span>
                    <input type="text" name="twitter"  class="form-control rounded-0" placeholder="X / Twitter" aria-label="Twitter" aria-describedby="social">
                </div><!-- X / Twitter !-->
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="Facebook" style="background: #3b5998; color: #fff;"><i class="bi bi-facebook"></i></span>
                    <input type="text" name="facebook"  class="form-control rounded-0" placeholder="Facebook" aria-label="Facebook" aria-describedby="social">
                </div><!-- Facebook !-->
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="Tiktok" style="background: #FE2C55; color: #fff;"><i class="bi bi-tiktok"></i></span>
                    <input type="text" name="tiktok"  class="form-control rounded-0" placeholder="TikTok" aria-label="Tiktok" aria-describedby="social">
                </div><!-- Tiktok !-->
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="LinkedIn" style="background: #0072b1; color: #fff;"><i class="bi bi-linkedin"></i></span>
                    <input type="text" name="linkedin"  class="form-control rounded-0" placeholder="LinkedIn" aria-label="LinkedIn" aria-describedby="social">
                </div><!-- LinkedIn !-->
                <div class=" input-group mb-2">
                    <span class="input-group-text" id="Snapchat" style="background: #ffcc00; color: #fff;"><i class="bi bi-snapchat"></i></span>
                    <input type="text" name="snapchat" class="form-control rounded-0" placeholder="Snapchat" aria-label="Snapchat" aria-describedby="social">
                </div><!-- Snapchat !-->
            </div><!-- Card !-->
        </div><!-- Col RIGHT !-->
    </div><!--Row Team Member Info !-->
    <div class="row  mt-3 mb-3">
        <div class="accordion accordion-flush" id="accordionFlushSEO">
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-title">
                    <button class="accordion-button collapsed bg-info bg-opacity-10" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                           Add SEO meta description and keywords
                    </button>
                </h2>
                <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-collapseTwo" data-bs-parent="#accordionFlushSEO">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col mb-3">
                                <label class="form-label"><strong>SEO Description</strong></label>
                                <textarea name="metadesc" class="form-control"   placeholder="Provide description(150 words) for SEO experience" maxlength="150"></textarea>
                            </div><!-- meta description !-->
                            <div class="col mb-3">
                                <label class="form-label"><strong>SEO Keywords</strong></label>
                                <textarea name="metakey" class="form-control"   placeholder="SEO Keywords separated by comma" maxlength="180"></textarea>
                            </div><!-- keywords !-->
                        </div><!-- row !-->
                    </div>
                </div>
            </div>
        </div><!-- Accordion !-->
    </div><!-- SEO Row !-->
    </form>

</div>
<!-- Modals !-->

<!-- JS !-->
<script>
  tinymce.init({
    selector: 'textarea#tiny, textarea#bio'
  });
  // Prevent Bootstrap dialog from blocking focusin
    document.addEventListener('focusin', (e) => {
  if (e.target.closest(".tox-tinymce, .tox-tinymce-aux, .moxman-window, .tam-assetmanager-root") !== null) {
    e.stopImmediatePropagation();
  }
});
</script>
<script src="<?= base_url();?>/assets/js/modules/teams.js"></script>

<?= $this->endSection();?>